/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.data;

import com.github.houbb.heaven.annotation.ThreadSafe;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordData;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.constant.enums.WordContainsTypeEnum;
import com.github.houbb.sensitive.word.support.data.WordDataTreeNode;
import java.util.Collection;

@ThreadSafe
public class WordDataTree
implements IWordData {
    private WordDataTreeNode root;

    @Override
    public synchronized void initWordData(Collection<String> collection) {
        WordDataTreeNode newRoot = new WordDataTreeNode();
        for (String word : collection) {
            char[] chars;
            if (StringUtil.isEmpty((String)word)) continue;
            WordDataTreeNode tempNode = newRoot;
            for (char c : chars = word.toCharArray()) {
                WordDataTreeNode subNode = tempNode.getSubNode(c);
                if (subNode == null) {
                    subNode = new WordDataTreeNode();
                    tempNode.addSubNode(c, subNode);
                }
                tempNode = subNode;
            }
            tempNode.end(true);
        }
        this.root = newRoot;
    }

    @Override
    public WordContainsTypeEnum contains(StringBuilder stringBuilder, InnerSensitiveWordContext innerContext) {
        WordDataTreeNode nowNode = this.root;
        int len = stringBuilder.length();
        for (int i = 0; i < len; ++i) {
            if (!ObjectUtil.isNull((Object)(nowNode = this.getNowMap(nowNode, i, stringBuilder, innerContext)))) continue;
            return WordContainsTypeEnum.NOT_FOUND;
        }
        if (nowNode.end()) {
            return WordContainsTypeEnum.CONTAINS_END;
        }
        return WordContainsTypeEnum.CONTAINS_PREFIX;
    }

    private WordDataTreeNode getNowMap(WordDataTreeNode nowNode, int index, StringBuilder stringBuilder, InnerSensitiveWordContext sensitiveContext) {
        char preMappingChar;
        IWordContext context = sensitiveContext.wordContext();
        char mappingChar = stringBuilder.charAt(index);
        WordDataTreeNode currentMap = nowNode.getSubNode(mappingChar);
        if (context.ignoreRepeat() && index > 0 && (preMappingChar = stringBuilder.charAt(index - 1)) == mappingChar) {
            currentMap = nowNode;
        }
        return currentMap;
    }
}

