/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.utils;

import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class InnerWordFormatUtils {
    private static final char[] EMPTY_CHARS = new char[0];

    private InnerWordFormatUtils() {
    }

    public static String format(String original, IWordContext context) {
        char[] chars;
        if (StringUtil.isEmpty((String)original)) {
            return original;
        }
        StringBuilder stringBuilder = new StringBuilder();
        IWordFormat charFormat = context.wordFormat();
        for (char c : chars = original.toCharArray()) {
            char cf = charFormat.format(c, context);
            stringBuilder.append(cf);
        }
        return stringBuilder.toString();
    }

    public static Map<Character, Character> formatCharsMapping(String original, IWordContext context) {
        if (StringUtil.isEmpty((String)original)) {
            return Collections.emptyMap();
        }
        int len = original.length();
        char[] rawChars = original.toCharArray();
        HashMap<Character, Character> map = new HashMap<Character, Character>(rawChars.length);
        IWordFormat charFormat = context.wordFormat();
        for (int i = 0; i < len; ++i) {
            char currentChar = rawChars[i];
            char formatChar = charFormat.format(currentChar, context);
            map.put(Character.valueOf(currentChar), Character.valueOf(formatChar));
        }
        return map;
    }

    public static List<String> formatWordList(List<String> list, IWordContext context) {
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        ArrayList<String> resultList = new ArrayList<String>(list.size());
        for (String word : list) {
            String formatWord = InnerWordFormatUtils.format(word, context);
            resultList.add(formatWord);
        }
        return resultList;
    }
}

