/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.core;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.sensitive.word.api.ISensitiveWord;
import com.github.houbb.sensitive.word.api.IWordCheck;
import com.github.houbb.sensitive.word.api.IWordContext;
import com.github.houbb.sensitive.word.api.IWordResult;
import com.github.houbb.sensitive.word.api.IWordResultCondition;
import com.github.houbb.sensitive.word.api.context.InnerSensitiveWordContext;
import com.github.houbb.sensitive.word.constant.enums.WordValidModeEnum;
import com.github.houbb.sensitive.word.core.AbstractSensitiveWord;
import com.github.houbb.sensitive.word.support.check.WordCheckResult;
import com.github.houbb.sensitive.word.support.result.WordResult;
import com.github.houbb.sensitive.word.utils.InnerWordFormatUtils;
import java.util.List;
import java.util.Map;

public class SensitiveWord
extends AbstractSensitiveWord {
    private static final ISensitiveWord INSTANCE = new SensitiveWord();

    public static ISensitiveWord getInstance() {
        return INSTANCE;
    }

    @Override
    protected List<IWordResult> doFindAll(String string, IWordContext context) {
        return this.innerSensitiveWords(string, WordValidModeEnum.FAIL_OVER, context);
    }

    private List<IWordResult> innerSensitiveWords(String text, WordValidModeEnum modeEnum, IWordContext context) {
        IWordCheck sensitiveCheck = context.sensitiveCheck();
        List resultList = Guavas.newArrayList();
        Map<Character, Character> characterCharacterMap = InnerWordFormatUtils.formatCharsMapping(text, context);
        InnerSensitiveWordContext checkContext = InnerSensitiveWordContext.newInstance().originalText(text).wordContext(context).modeEnum(WordValidModeEnum.FAIL_OVER).formatCharMapping(characterCharacterMap);
        IWordResultCondition wordResultCondition = context.wordResultCondition();
        for (int i = 0; i < text.length(); ++i) {
            WordCheckResult checkResult = sensitiveCheck.sensitiveCheck(i, checkContext);
            int wordLength = checkResult.index();
            if (wordLength <= 0) continue;
            WordResult wordResult = WordResult.newInstance().startIndex(i).endIndex(i + wordLength);
            if (wordResultCondition.match(wordResult, text, modeEnum, context)) {
                resultList.add(wordResult);
            }
            if (WordValidModeEnum.FAIL_FAST.equals((Object)modeEnum)) break;
            i += wordLength - 1;
        }
        return resultList;
    }
}

