/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.sensitive.word.support.format;

import com.github.houbb.heaven.support.pipeline.Pipeline;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.sensitive.word.api.IWordFormat;
import com.github.houbb.sensitive.word.support.format.WordFormatIgnoreCase;
import com.github.houbb.sensitive.word.support.format.WordFormatIgnoreChineseStyle;
import com.github.houbb.sensitive.word.support.format.WordFormatIgnoreEnglishStyle;
import com.github.houbb.sensitive.word.support.format.WordFormatIgnoreNumStyle;
import com.github.houbb.sensitive.word.support.format.WordFormatIgnoreWidth;
import com.github.houbb.sensitive.word.support.format.WordFormatInit;
import com.github.houbb.sensitive.word.support.format.WordFormatNone;
import java.util.Collection;

public final class WordFormats {
    private WordFormats() {
    }

    public static IWordFormat chains(final IWordFormat ... charFormats) {
        if (ArrayUtil.isEmpty((Object[])charFormats)) {
            return WordFormats.none();
        }
        return new WordFormatInit(){

            @Override
            protected void init(Pipeline<IWordFormat> pipeline) {
                for (IWordFormat charFormat : charFormats) {
                    pipeline.addLast((Object)charFormat);
                }
            }
        };
    }

    public static IWordFormat chains(final Collection<IWordFormat> charFormats) {
        if (CollectionUtil.isEmpty(charFormats)) {
            return WordFormats.none();
        }
        return new WordFormatInit(){

            @Override
            protected void init(Pipeline<IWordFormat> pipeline) {
                for (IWordFormat charFormat : charFormats) {
                    pipeline.addLast((Object)charFormat);
                }
            }
        };
    }

    public static IWordFormat none() {
        return WordFormatNone.getInstance();
    }

    public static IWordFormat ignoreCase() {
        return WordFormatIgnoreCase.getInstance();
    }

    public static IWordFormat ignoreEnglishStyle() {
        return WordFormatIgnoreEnglishStyle.getInstance();
    }

    public static IWordFormat ignoreChineseStyle() {
        return WordFormatIgnoreChineseStyle.getInstance();
    }

    public static IWordFormat ignoreNumStyle() {
        return WordFormatIgnoreNumStyle.getInstance();
    }

    public static IWordFormat ignoreWidth() {
        return WordFormatIgnoreWidth.getInstance();
    }
}

