/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet;

import com.github.lkqm.hcnet.DeviceTemplateOptions;
import com.github.lkqm.hcnet.HCNetSDK;
import com.github.lkqm.hcnet.HikResult;
import com.github.lkqm.hcnet.Token;
import com.github.lkqm.hcnet.model.PassThroughResponse;
import com.github.lkqm.hcnet.model.ResponseStatus;
import com.github.lkqm.hcnet.options.MaintainOptions;
import com.github.lkqm.hcnet.options.MaintainOptionsImpl;
import com.github.lkqm.hcnet.options.PtzOptions;
import com.github.lkqm.hcnet.options.PtzOptionsImpl;
import com.github.lkqm.hcnet.options.SdkOptions;
import com.github.lkqm.hcnet.options.SdkOptionsImpl;
import com.github.lkqm.hcnet.util.BiFunction;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import java.util.Objects;
import lombok.NonNull;

public class HikDeviceTemplate
implements DeviceTemplateOptions {
    public static final int DEFAULT_PORT = 8000;
    @NonNull
    private final HCNetSDK hcnetsdk;

    public HikDeviceTemplate(@NonNull HCNetSDK hcnetsdk) {
        if (hcnetsdk == null) {
            throw new NullPointerException("hcnetsdk is marked non-null but is null");
        }
        hcnetsdk.NET_DVR_Init();
        this.hcnetsdk = hcnetsdk;
    }

    @Override
    public HikResult<Token> login(String ip, int port, String user, String password) {
        HCNetSDK.NET_DVR_USER_LOGIN_INFO loginInfo = new HCNetSDK.NET_DVR_USER_LOGIN_INFO();
        System.arraycopy(ip.getBytes(), 0, loginInfo.sDeviceAddress, 0, ip.length());
        loginInfo.wPort = (short)port;
        System.arraycopy(user.getBytes(), 0, loginInfo.sUserName, 0, user.length());
        System.arraycopy(password.getBytes(), 0, loginInfo.sPassword, 0, password.length());
        loginInfo.bUseAsynLogin = 0;
        loginInfo.write();
        HCNetSDK.NET_DVR_DEVICEINFO_V40 deviceInfo = new HCNetSDK.NET_DVR_DEVICEINFO_V40();
        NativeLong userId = this.hcnetsdk.NET_DVR_Login_V40(loginInfo.getPointer(), deviceInfo.getPointer());
        deviceInfo.read();
        if (userId.longValue() == -1L) {
            return this.lastError();
        }
        Token token = Token.builder().userId(userId.longValue()).deviceSerialNumber(new String(deviceInfo.struDeviceV30.sSerialNumber).trim()).build();
        return HikResult.ok(token);
    }

    @Override
    public HikResult<?> logout(long userId) {
        boolean result;
        if (userId > -1L && !(result = this.hcnetsdk.NET_DVR_Logout(new NativeLong(userId)))) {
            return this.lastError();
        }
        return HikResult.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HikResult<?> doAction(String ip, int port, String user, String password, BiFunction<HCNetSDK, Token, HikResult<?>> action) {
        HikResult<Token> loginResult = this.login(ip, port, user, password);
        if (!loginResult.isSuccess()) {
            return loginResult;
        }
        Token token = loginResult.getData();
        try {
            HikResult<Object> result = action.apply(this.hcnetsdk, token);
            if (result == null) {
                result = HikResult.ok();
            }
            HikResult<?> hikResult = result;
            return hikResult;
        }
        finally {
            this.logout(token.getUserId());
        }
    }

    @Override
    public <T> HikResult<T> lastError() {
        int code = this.hcnetsdk.NET_DVR_GetLastError();
        if (code == 0) {
            return null;
        }
        String msg = code == 3 ? "sdk not init." : this.hcnetsdk.NET_DVR_GetErrorMsg(new NativeLongByReference(new NativeLong((long)code)));
        return HikResult.fail(code, msg);
    }

    @Override
    public HikResult<PassThroughResponse> passThrough(long userId, String url, String input) {
        byte[] bytes = input == null ? null : input.getBytes();
        return this.passThrough(userId, url, bytes, 0x300000);
    }

    @Override
    public HikResult<PassThroughResponse> passThrough(long userId, String url, byte[] inputBytes, int exceptOutByteSize) {
        byte[] urlBytes = url.getBytes();
        inputBytes = inputBytes == null || inputBytes.length == 0 ? " ".getBytes() : inputBytes;
        HCNetSDK.NET_DVR_STRING_POINTER urlPointer = new HCNetSDK.NET_DVR_STRING_POINTER();
        urlPointer.byString = urlBytes;
        urlPointer.write();
        HCNetSDK.NET_DVR_STRING_POINTER inputPointer = new HCNetSDK.NET_DVR_STRING_POINTER();
        inputPointer.byString = inputBytes;
        inputPointer.write();
        HCNetSDK.NET_DVR_XML_CONFIG_INPUT inputParams = new HCNetSDK.NET_DVR_XML_CONFIG_INPUT();
        inputParams.dwSize = inputParams.size();
        inputParams.lpRequestUrl = urlPointer.getPointer();
        inputParams.dwRequestUrlLen = urlPointer.byString.length;
        inputParams.lpInBuffer = inputPointer.getPointer();
        inputParams.dwInBufferSize = inputPointer.byString.length;
        inputParams.write();
        HCNetSDK.NET_DVR_STRING_POINTER outputPointer = new HCNetSDK.NET_DVR_STRING_POINTER();
        outputPointer.byString = new byte[exceptOutByteSize];
        HCNetSDK.NET_DVR_STRING_POINTER outputStatusPointer = new HCNetSDK.NET_DVR_STRING_POINTER();
        HCNetSDK.NET_DVR_XML_CONFIG_OUTPUT outputParams = new HCNetSDK.NET_DVR_XML_CONFIG_OUTPUT();
        outputParams.dwSize = outputParams.size();
        outputParams.lpOutBuffer = outputPointer.getPointer();
        outputParams.dwOutBufferSize = outputPointer.size();
        outputParams.lpStatusBuffer = outputStatusPointer.getPointer();
        outputParams.dwStatusSize = outputStatusPointer.size();
        inputPointer.write();
        boolean result = this.hcnetsdk.NET_DVR_STDXMLConfig(new NativeLong(userId), inputParams, outputParams);
        outputPointer.read();
        outputStatusPointer.read();
        byte[] data = outputPointer.byString;
        byte[] statusData = outputStatusPointer.byString;
        String statusXml = new String(statusData).trim();
        HikResult<PassThroughResponse> hikResult = new HikResult<PassThroughResponse>();
        PassThroughResponse response = new PassThroughResponse();
        if (!result) {
            HikResult error = this.lastError();
            hikResult.set(error);
            if (statusXml.trim().length() > 0) {
                response.setStatus(ResponseStatus.ofXml(statusXml));
            }
        } else {
            hikResult.setSuccess(true);
            response.setBytes(data);
        }
        hikResult.setData(response);
        return hikResult;
    }

    @Override
    public HikResult<Long> setupDeploy(long userId, HCNetSDK.FMSGCallBack messageCallback, HCNetSDK.FExceptionCallBack exceptionCallback) {
        boolean setExceptionResult;
        boolean result;
        if (messageCallback != null && !(result = this.hcnetsdk.NET_DVR_SetDVRMessageCallBack_V30(messageCallback, null))) {
            return this.lastError();
        }
        NativeLong setupAlarmHandle = this.hcnetsdk.NET_DVR_SetupAlarmChan_V30(new NativeLong(userId));
        if (setupAlarmHandle.longValue() == -1L) {
            return this.lastError();
        }
        if (exceptionCallback != null && !(setExceptionResult = this.hcnetsdk.NET_DVR_SetExceptionCallBack_V30(0, setupAlarmHandle.intValue(), exceptionCallback, null))) {
            this.hcnetsdk.NET_DVR_CloseAlarmChan_V30(setupAlarmHandle);
            return this.lastError();
        }
        return HikResult.ok(setupAlarmHandle.longValue());
    }

    @Override
    public HikResult<?> modifyPassword(long userId, String username, String newPassword) {
        HCNetSDK.NET_DVR_USER_V30 dvrUser = new HCNetSDK.NET_DVR_USER_V30();
        boolean getResult = this.hcnetsdk.NET_DVR_GetDVRConfig(new NativeLong(userId), 1006, new NativeLong(0L), dvrUser.getPointer(), dvrUser.size(), new IntByReference(0));
        if (!getResult) {
            HikResult errorResult = this.lastError();
            errorResult.setSuccess(false);
            return errorResult;
        }
        dvrUser.read();
        for (HCNetSDK.NET_DVR_USER_INFO_V30 userInfo2 : dvrUser.struUser) {
            String name = new String(userInfo2.sUserName).trim();
            if (!Objects.equals(username, name)) continue;
            userInfo2.sPassword = newPassword.getBytes();
        }
        dvrUser.write();
        boolean setResult = this.hcnetsdk.NET_DVR_SetDVRConfig(new NativeLong(userId), 1007, new NativeLong(0L), dvrUser.getPointer(), dvrUser.dwSize);
        if (!setResult) {
            HikResult errorResult = this.lastError();
            errorResult.setSuccess(false);
            return errorResult;
        }
        return HikResult.ok();
    }

    @Override
    public HikResult<?> nvrRebindChannels(long userId, String dvrUsername, String dvrNewPassword) {
        IntByReference ibrBytesReturned = new IntByReference(0);
        HCNetSDK.NET_DVR_IPPARACFG mStrIpparaCfg = new HCNetSDK.NET_DVR_IPPARACFG();
        mStrIpparaCfg.write();
        Pointer lpIpParaConfig = mStrIpparaCfg.getPointer();
        boolean getResult = this.hcnetsdk.NET_DVR_GetDVRConfig(new NativeLong(userId), 1048, new NativeLong(33L), lpIpParaConfig, mStrIpparaCfg.size(), ibrBytesReturned);
        if (!getResult) {
            HikResult errorResult = this.lastError();
            errorResult.setSuccess(false);
            return errorResult;
        }
        mStrIpparaCfg.read();
        for (HCNetSDK.NET_DVR_IPDEVINFO deviceInfo : mStrIpparaCfg.struIPDevInfo) {
            String user = new String(deviceInfo.sUserName).trim();
            if (!Objects.equals(dvrUsername, user)) continue;
            deviceInfo.sPassword = dvrNewPassword.getBytes();
            String string = new String(deviceInfo.struIP.sIpV4).trim();
        }
        mStrIpparaCfg.write();
        boolean setResult = this.hcnetsdk.NET_DVR_SetDVRConfig(new NativeLong(userId), 1049, new NativeLong(33L), mStrIpparaCfg.getPointer(), mStrIpparaCfg.dwSize);
        if (!setResult) {
            HikResult errorResult = this.lastError();
            errorResult.setSuccess(false);
            return errorResult;
        }
        return HikResult.ok();
    }

    @Override
    public <T extends Structure> HikResult<T> getDvrConfig(long userId, long channel, int command, Class<T> clazz) {
        Structure data = (Structure)clazz.newInstance();
        data.write();
        boolean result = this.hcnetsdk.NET_DVR_GetDVRConfig(new NativeLong(userId), command, new NativeLong(channel), data.getPointer(), data.size(), new IntByReference(0));
        if (!result) {
            return this.lastError();
        }
        data.read();
        return HikResult.ok(data);
    }

    @Override
    public HikResult<?> getDvrConfig(long userId, long channel, int command, Structure data) {
        data.write();
        boolean result = this.hcnetsdk.NET_DVR_GetDVRConfig(new NativeLong(userId), command, new NativeLong(channel), data.getPointer(), data.size(), new IntByReference(0));
        if (!result) {
            return this.lastError();
        }
        data.read();
        return HikResult.ok();
    }

    @Override
    public HikResult<?> setDvrConfig(long userId, long channel, int command, Structure data) {
        data.write();
        boolean result = this.hcnetsdk.NET_DVR_SetDVRConfig(new NativeLong(userId), command, new NativeLong(channel), data.getPointer(), data.size());
        if (!result) {
            return this.lastError();
        }
        return HikResult.ok();
    }

    @Override
    public HikResult<Long> realPlay(long userId, HCNetSDK.FRealDataCallBack_V30 callback) {
        HCNetSDK.NET_DVR_PREVIEWINFO previewInfo = new HCNetSDK.NET_DVR_PREVIEWINFO();
        previewInfo.lChannel = new NativeLong(1L);
        previewInfo.dwStreamType = 0;
        previewInfo.dwLinkMode = 1;
        previewInfo.hPlayWnd = null;
        previewInfo.bBlocked = false;
        previewInfo.bPassbackRecord = false;
        previewInfo.byPreviewMode = 0;
        return this.realPlay(userId, previewInfo, callback);
    }

    @Override
    public HikResult<Long> realPlay(long userId, HCNetSDK.NET_DVR_PREVIEWINFO previewInfo, HCNetSDK.FRealDataCallBack_V30 callback) {
        NativeLong realPlayHandle = this.hcnetsdk.NET_DVR_RealPlay_V40(new NativeLong(userId), previewInfo, callback, null);
        if (realPlayHandle.longValue() == -1L) {
            return this.lastError();
        }
        return HikResult.ok(realPlayHandle.longValue());
    }

    @Override
    public HikResult<?> stopRealPlay(long realHandle) {
        boolean result = this.hcnetsdk.NET_DVR_StopRealPlay(new NativeLong(realHandle));
        return result ? HikResult.ok() : this.lastError();
    }

    @Override
    public SdkOptions opsForSdk() {
        return new SdkOptionsImpl(this);
    }

    @Override
    public MaintainOptions opsForMaintain(long userId) {
        return new MaintainOptionsImpl(this, userId);
    }

    @Override
    public PtzOptions opsForPtz(long userId) {
        return new PtzOptionsImpl(this, userId);
    }

    @NonNull
    public HCNetSDK getHcnetsdk() {
        return this.hcnetsdk;
    }
}

