/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import sun.awt.OSInfo;

public class JnaPathUtils {
    public static final String JNA_PATH_PROPERTY_NAME = "jna.library.path";

    public static boolean initJnaLibraryPathDev() {
        return JnaPathUtils.initJnaLibraryPath(null, false);
    }

    public static boolean initJnaLibraryPath(Class<?> target) {
        return JnaPathUtils.initJnaLibraryPath(target, true);
    }

    public static boolean initJnaLibraryPath(Class<?> target, boolean effectiveJar) {
        boolean isJnaLibEmpty;
        boolean modifiedPath = false;
        String jnaLibPath = System.getProperty(JNA_PATH_PROPERTY_NAME);
        boolean bl = isJnaLibEmpty = jnaLibPath == null || jnaLibPath.trim().length() == 0;
        if (isJnaLibEmpty) {
            HashMap<OSInfo.OSType, String> libDirMap = new HashMap<OSInfo.OSType, String>();
            libDirMap.put(OSInfo.OSType.WINDOWS, "natives/dll");
            libDirMap.put(OSInfo.OSType.LINUX, "natives/so");
            libDirMap.put(OSInfo.OSType.MACOSX, "natives/dylib");
            String libDir = (String)libDirMap.get((Object)OSInfo.getOSType());
            if (libDir == null) {
                throw new RuntimeException("Unsupported operator system: " + OSInfo.getOSType().name());
            }
            if (!JnaPathUtils.isRunJar()) {
                URL uri = JnaPathUtils.class.getClassLoader().getResource(libDir);
                if (uri == null) {
                    throw new IllegalStateException("Not found relation library: " + libDir);
                }
                jnaLibPath = uri.getPath();
                System.setProperty(JNA_PATH_PROPERTY_NAME, jnaLibPath);
                modifiedPath = true;
            } else if (effectiveJar) {
                jnaLibPath = JnaPathUtils.getJarDirectoryPath(target) + File.separator + libDir;
                System.setProperty(JNA_PATH_PROPERTY_NAME, jnaLibPath);
                modifiedPath = true;
            }
        }
        return modifiedPath;
    }

    public static boolean isRunJar() {
        URL resource = JnaPathUtils.class.getResource("/");
        if (resource == null) {
            resource = JnaPathUtils.class.getResource("");
        }
        if (resource == null) {
            return false;
        }
        String protocol = resource.getProtocol();
        return "jar".equals(protocol);
    }

    public static String getJarDirectoryPath(Class<?> target) {
        URL url = JnaPathUtils.getLocation(target);
        File file = JnaPathUtils.urlToFile(url);
        return file.getParent();
    }

    private static URL getLocation(Class<?> c) {
        String suffix;
        if (c == null) {
            return null;
        }
        try {
            URL codeSourceLocation = c.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                return codeSourceLocation;
            }
        }
        catch (SecurityException codeSourceLocation) {
        }
        catch (NullPointerException codeSourceLocation) {
            // empty catch block
        }
        URL classResource = c.getResource(c.getSimpleName() + ".class");
        if (classResource == null) {
            return null;
        }
        String url = classResource.toString();
        if (!url.endsWith(suffix = c.getCanonicalName().replace('.', '/') + ".class")) {
            return null;
        }
        String base = url.substring(0, url.length() - suffix.length());
        String path = base;
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length() - 2);
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File urlToFile(URL url) {
        return url == null ? null : JnaPathUtils.urlToFile(url.toString());
    }

    private static File urlToFile(String url) {
        String path = url;
        if (path.startsWith("jar:")) {
            int index = path.indexOf("!/");
            path = path.substring(4, index);
        }
        try {
            if (OSInfo.getOSType() == OSInfo.OSType.WINDOWS && path.matches("file:[A-Za-z]:.*")) {
                path = "file:/" + path.substring(5);
            }
            return new File(new URL(path).toURI());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
            return new File(path);
        }
        throw new IllegalArgumentException("Invalid URL: " + url);
    }
}

