/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.handler;

import com.github.lkqm.hcnet.handler.AbstractFaceSnapHandler;
import com.github.lkqm.hcnet.model.DeviceInfo;
import com.github.lkqm.hcnet.model.FaceSnapEvent;
import com.github.lkqm.hcnet.model.FaceSnapInfo;
import com.github.lkqm.hcnet.util.InnerUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FaceSnapFileStoreHandler
extends AbstractFaceSnapHandler {
    protected final String baseDir;
    private static final String FILE_NAME_TPL = "%s_%s_%s_%s.jpg";

    @Override
    public void handle(FaceSnapEvent event) {
        byte[] backgroundBytes;
        DeviceInfo deviceInfo = event.getDeviceInfo();
        FaceSnapInfo snapInfo = event.getFaceSnapInfo();
        byte[] faceBytes = snapInfo.getFaceImageBytes();
        if (faceBytes != null) {
            String facePath = this.baseDir + File.separator + this.getFacePictureFileName(event);
            InnerUtils.writeFile(faceBytes, facePath);
        }
        if ((backgroundBytes = snapInfo.getBackgroundImageBytes()) != null) {
            String backgroundPath = this.baseDir + File.separator + this.getBackgroundPictureFileName(event);
            InnerUtils.writeFile(backgroundBytes, backgroundPath);
        }
    }

    protected String getFacePictureFileName(FaceSnapEvent event) {
        return this.doPictureName(event, "face");
    }

    private String getBackgroundPictureFileName(FaceSnapEvent event) {
        return this.doPictureName(event, "bk");
    }

    private String doPictureName(FaceSnapEvent event, String type) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMMdd");
        DeviceInfo deviceInfo = event.getDeviceInfo();
        FaceSnapInfo snapInfo = event.getFaceSnapInfo();
        Date snapDate = new Date(snapInfo.getSnapTimestamp());
        String snapTime = sdf.format(snapDate);
        String day = sdf2.format(snapDate);
        return day + File.separator + String.format(FILE_NAME_TPL, snapTime, deviceInfo.getDeviceIp(), deviceInfo.getSerialNumber(), type);
    }

    public FaceSnapFileStoreHandler(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }
}

