/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.model;

import java.io.Serializable;
import java.util.Arrays;

public class FaceSnapInfo
implements Serializable {
    private int facePicId;
    private int faceScore;
    private byte[] faceImageBytes;
    private byte[] backgroundImageBytes;
    private long snapTimestamp;
    private long stayDurationMs;
    private int repeatTimes;
    private FaceRect faceRect;
    private FaceFuture faceFuture;

    public int getFacePicId() {
        return this.facePicId;
    }

    public int getFaceScore() {
        return this.faceScore;
    }

    public byte[] getFaceImageBytes() {
        return this.faceImageBytes;
    }

    public byte[] getBackgroundImageBytes() {
        return this.backgroundImageBytes;
    }

    public long getSnapTimestamp() {
        return this.snapTimestamp;
    }

    public long getStayDurationMs() {
        return this.stayDurationMs;
    }

    public int getRepeatTimes() {
        return this.repeatTimes;
    }

    public FaceRect getFaceRect() {
        return this.faceRect;
    }

    public FaceFuture getFaceFuture() {
        return this.faceFuture;
    }

    public void setFacePicId(int facePicId) {
        this.facePicId = facePicId;
    }

    public void setFaceScore(int faceScore) {
        this.faceScore = faceScore;
    }

    public void setFaceImageBytes(byte[] faceImageBytes) {
        this.faceImageBytes = faceImageBytes;
    }

    public void setBackgroundImageBytes(byte[] backgroundImageBytes) {
        this.backgroundImageBytes = backgroundImageBytes;
    }

    public void setSnapTimestamp(long snapTimestamp) {
        this.snapTimestamp = snapTimestamp;
    }

    public void setStayDurationMs(long stayDurationMs) {
        this.stayDurationMs = stayDurationMs;
    }

    public void setRepeatTimes(int repeatTimes) {
        this.repeatTimes = repeatTimes;
    }

    public void setFaceRect(FaceRect faceRect) {
        this.faceRect = faceRect;
    }

    public void setFaceFuture(FaceFuture faceFuture) {
        this.faceFuture = faceFuture;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FaceSnapInfo)) {
            return false;
        }
        FaceSnapInfo other = (FaceSnapInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFacePicId() != other.getFacePicId()) {
            return false;
        }
        if (this.getFaceScore() != other.getFaceScore()) {
            return false;
        }
        if (this.getSnapTimestamp() != other.getSnapTimestamp()) {
            return false;
        }
        if (this.getStayDurationMs() != other.getStayDurationMs()) {
            return false;
        }
        if (this.getRepeatTimes() != other.getRepeatTimes()) {
            return false;
        }
        if (!Arrays.equals(this.getFaceImageBytes(), other.getFaceImageBytes())) {
            return false;
        }
        if (!Arrays.equals(this.getBackgroundImageBytes(), other.getBackgroundImageBytes())) {
            return false;
        }
        FaceRect this$faceRect = this.getFaceRect();
        FaceRect other$faceRect = other.getFaceRect();
        if (this$faceRect == null ? other$faceRect != null : !((Object)this$faceRect).equals(other$faceRect)) {
            return false;
        }
        FaceFuture this$faceFuture = this.getFaceFuture();
        FaceFuture other$faceFuture = other.getFaceFuture();
        return !(this$faceFuture == null ? other$faceFuture != null : !((Object)this$faceFuture).equals(other$faceFuture));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FaceSnapInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFacePicId();
        result = result * 59 + this.getFaceScore();
        long $snapTimestamp = this.getSnapTimestamp();
        result = result * 59 + (int)($snapTimestamp >>> 32 ^ $snapTimestamp);
        long $stayDurationMs = this.getStayDurationMs();
        result = result * 59 + (int)($stayDurationMs >>> 32 ^ $stayDurationMs);
        result = result * 59 + this.getRepeatTimes();
        result = result * 59 + Arrays.hashCode(this.getFaceImageBytes());
        result = result * 59 + Arrays.hashCode(this.getBackgroundImageBytes());
        FaceRect $faceRect = this.getFaceRect();
        result = result * 59 + ($faceRect == null ? 43 : ((Object)$faceRect).hashCode());
        FaceFuture $faceFuture = this.getFaceFuture();
        result = result * 59 + ($faceFuture == null ? 43 : ((Object)$faceFuture).hashCode());
        return result;
    }

    public String toString() {
        return "FaceSnapInfo(facePicId=" + this.getFacePicId() + ", faceScore=" + this.getFaceScore() + ", faceImageBytes=" + Arrays.toString(this.getFaceImageBytes()) + ", backgroundImageBytes=" + Arrays.toString(this.getBackgroundImageBytes()) + ", snapTimestamp=" + this.getSnapTimestamp() + ", stayDurationMs=" + this.getStayDurationMs() + ", repeatTimes=" + this.getRepeatTimes() + ", faceRect=" + this.getFaceRect() + ", faceFuture=" + this.getFaceFuture() + ")";
    }

    public static class FaceRect
    implements Serializable {
        private float x;
        private float y;
        private float width;
        private float height;

        public FaceRect(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public void setX(float x) {
            this.x = x;
        }

        public void setY(float y) {
            this.y = y;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public void setHeight(float height) {
            this.height = height;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FaceRect)) {
                return false;
            }
            FaceRect other = (FaceRect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getX(), other.getX()) != 0) {
                return false;
            }
            if (Float.compare(this.getY(), other.getY()) != 0) {
                return false;
            }
            if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
                return false;
            }
            return Float.compare(this.getHeight(), other.getHeight()) == 0;
        }

        protected boolean canEqual(Object other) {
            return other instanceof FaceRect;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getX());
            result = result * 59 + Float.floatToIntBits(this.getY());
            result = result * 59 + Float.floatToIntBits(this.getWidth());
            result = result * 59 + Float.floatToIntBits(this.getHeight());
            return result;
        }

        public String toString() {
            return "FaceSnapInfo.FaceRect(x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ")";
        }
    }

    public static class FaceFuture
    implements Serializable {
        private int ageGroup;
        private int sex;
        private int eyeGlass;
        private int age;
        private int ageDeviation;
        private int mask;
        private int smile;
        private int hat;

        public int getAgeGroup() {
            return this.ageGroup;
        }

        public int getSex() {
            return this.sex;
        }

        public int getEyeGlass() {
            return this.eyeGlass;
        }

        public int getAge() {
            return this.age;
        }

        public int getAgeDeviation() {
            return this.ageDeviation;
        }

        public int getMask() {
            return this.mask;
        }

        public int getSmile() {
            return this.smile;
        }

        public int getHat() {
            return this.hat;
        }

        public void setAgeGroup(int ageGroup) {
            this.ageGroup = ageGroup;
        }

        public void setSex(int sex) {
            this.sex = sex;
        }

        public void setEyeGlass(int eyeGlass) {
            this.eyeGlass = eyeGlass;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public void setAgeDeviation(int ageDeviation) {
            this.ageDeviation = ageDeviation;
        }

        public void setMask(int mask) {
            this.mask = mask;
        }

        public void setSmile(int smile) {
            this.smile = smile;
        }

        public void setHat(int hat) {
            this.hat = hat;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FaceFuture)) {
                return false;
            }
            FaceFuture other = (FaceFuture)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAgeGroup() != other.getAgeGroup()) {
                return false;
            }
            if (this.getSex() != other.getSex()) {
                return false;
            }
            if (this.getEyeGlass() != other.getEyeGlass()) {
                return false;
            }
            if (this.getAge() != other.getAge()) {
                return false;
            }
            if (this.getAgeDeviation() != other.getAgeDeviation()) {
                return false;
            }
            if (this.getMask() != other.getMask()) {
                return false;
            }
            if (this.getSmile() != other.getSmile()) {
                return false;
            }
            return this.getHat() == other.getHat();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FaceFuture;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAgeGroup();
            result = result * 59 + this.getSex();
            result = result * 59 + this.getEyeGlass();
            result = result * 59 + this.getAge();
            result = result * 59 + this.getAgeDeviation();
            result = result * 59 + this.getMask();
            result = result * 59 + this.getSmile();
            result = result * 59 + this.getHat();
            return result;
        }

        public String toString() {
            return "FaceSnapInfo.FaceFuture(ageGroup=" + this.getAgeGroup() + ", sex=" + this.getSex() + ", eyeGlass=" + this.getEyeGlass() + ", age=" + this.getAge() + ", ageDeviation=" + this.getAgeDeviation() + ", mask=" + this.getMask() + ", smile=" + this.getSmile() + ", hat=" + this.getHat() + ")";
        }
    }
}

