/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.options;

import com.github.lkqm.hcnet.HCNetSDK;
import com.github.lkqm.hcnet.HikDeviceTemplate;
import com.github.lkqm.hcnet.HikResult;
import com.github.lkqm.hcnet.model.UpgradeAsyncResponse;
import com.github.lkqm.hcnet.model.UpgradeResponse;
import com.github.lkqm.hcnet.options.BaseOptions;
import com.github.lkqm.hcnet.options.MaintainOptions;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

public class MaintainOptionsImpl
extends BaseOptions
implements MaintainOptions {
    private final NativeLong userId;

    public MaintainOptionsImpl(HikDeviceTemplate deviceTemplate, long userId) {
        super(deviceTemplate);
        this.userId = new NativeLong(userId);
    }

    @Override
    public boolean isOnline() {
        return this.getHcnetsdk().NET_DVR_RemoteControl(this.userId, 20005, null, 0);
    }

    @Override
    public HikResult<?> reboot() {
        boolean rebootResult = this.getHcnetsdk().NET_DVR_RebootDVR(this.userId);
        if (!rebootResult) {
            return this.lastError();
        }
        return HikResult.ok();
    }

    @Override
    public HikResult<Date> getDeviceTime() {
        HCNetSDK.NET_DVR_TIME netDvrTime = new HCNetSDK.NET_DVR_TIME();
        HikResult<?> result = this.deviceTemplate.getDvrConfig(this.userId.longValue(), 0L, 118, netDvrTime);
        if (!result.isSuccess()) {
            return HikResult.fail(result.getErrorCode(), result.getErrorMsg());
        }
        netDvrTime.read();
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, netDvrTime.dwYear);
        calendar.set(2, netDvrTime.dwMonth - 1);
        calendar.set(5, netDvrTime.dwDay);
        calendar.set(11, netDvrTime.dwHour);
        calendar.set(12, netDvrTime.dwMinute);
        calendar.set(13, netDvrTime.dwSecond);
        return HikResult.ok(calendar.getTime());
    }

    @Override
    public HikResult<?> setDeviceTime(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        HCNetSDK.NET_DVR_TIME netDvrTime = new HCNetSDK.NET_DVR_TIME();
        netDvrTime.dwYear = calendar.get(1);
        netDvrTime.dwMonth = calendar.get(2) + 1;
        netDvrTime.dwDay = calendar.get(5);
        netDvrTime.dwHour = calendar.get(11);
        netDvrTime.dwMinute = calendar.get(12);
        netDvrTime.dwSecond = calendar.get(13);
        return this.deviceTemplate.setDvrConfig(this.userId.longValue(), 0L, 119, netDvrTime);
    }

    @Override
    public HikResult<UpgradeResponse> upgradeSyncForDVR(String sdkPath) {
        HikResult<UpgradeAsyncResponse> upgradeResult = this.upgradeAsyncForDVR(sdkPath);
        if (!upgradeResult.isSuccess()) {
            return HikResult.fail(upgradeResult.getErrorCode(), upgradeResult.getErrorMsg());
        }
        UpgradeAsyncResponse asyncResponse = upgradeResult.getData();
        UpgradeResponse response = asyncResponse.getFuture().get();
        return HikResult.ok(response);
    }

    @Override
    public HikResult<UpgradeResponse> upgradeSyncForACS(String sdkPath, int deviceNo) {
        HCNetSDK.NET_DVR_UPGRADE_PARAM upgradeParam = new HCNetSDK.NET_DVR_UPGRADE_PARAM();
        upgradeParam.dwUpgradeType = 0;
        upgradeParam.sFilename = sdkPath;
        upgradeParam.pInbuffer = new IntByReference(deviceNo).getPointer();
        upgradeParam.dwBufferLen = 4;
        return this.upgradeSync(upgradeParam);
    }

    @Override
    public HikResult<UpgradeResponse> upgradeSync(HCNetSDK.NET_DVR_UPGRADE_PARAM upgradeParam) {
        HikResult<UpgradeAsyncResponse> upgradeResult = this.upgradeAsync(upgradeParam);
        if (!upgradeResult.isSuccess()) {
            return HikResult.fail(upgradeResult.getErrorCode(), upgradeResult.getErrorMsg());
        }
        UpgradeAsyncResponse asyncResponse = upgradeResult.getData();
        UpgradeResponse response = asyncResponse.getFuture().get();
        return HikResult.ok(response);
    }

    @Override
    public HikResult<UpgradeAsyncResponse> upgradeAsyncForDVR(String sdkPath) {
        HCNetSDK.NET_DVR_UPGRADE_PARAM upgradeParam = new HCNetSDK.NET_DVR_UPGRADE_PARAM();
        upgradeParam.dwUpgradeType = 0;
        upgradeParam.sFilename = sdkPath;
        return this.upgradeAsync(upgradeParam);
    }

    @Override
    public HikResult<UpgradeAsyncResponse> upgradeAsyncForACS(String sdkPath, int deviceNo) {
        HCNetSDK.NET_DVR_UPGRADE_PARAM upgradeParam = new HCNetSDK.NET_DVR_UPGRADE_PARAM();
        upgradeParam.dwUpgradeType = 0;
        upgradeParam.sFilename = sdkPath;
        upgradeParam.pInbuffer = new IntByReference(deviceNo).getPointer();
        upgradeParam.dwBufferLen = 4;
        return this.upgradeAsync(upgradeParam);
    }

    @Override
    public HikResult<UpgradeAsyncResponse> upgradeAsync(HCNetSDK.NET_DVR_UPGRADE_PARAM upgradeParam) {
        upgradeParam.write();
        final NativeLong upgradeHandle = this.getHcnetsdk().NET_DVR_Upgrade_V50(this.userId, upgradeParam);
        if (upgradeHandle.longValue() == -1L) {
            return this.lastError();
        }
        FutureTask<UpgradeResponse> future = new FutureTask<UpgradeResponse>(new Callable<UpgradeResponse>(){

            @Override
            public UpgradeResponse call() throws Exception {
                int state;
                int errorTimes = 0;
                do {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
                    state = MaintainOptionsImpl.this.getHcnetsdk().NET_DVR_GetUpgradeState(upgradeHandle);
                    if (state == -1) {
                        ++errorTimes;
                        continue;
                    }
                    errorTimes = 0;
                } while (state == 2 || state == -1 && errorTimes >= 3);
                UpgradeResponse response = new UpgradeResponse();
                response.setHandle(upgradeHandle.longValue());
                response.setState(state);
                if (state == -1) {
                    response.setError(MaintainOptionsImpl.this.lastError());
                } else {
                    MaintainOptionsImpl.this.getHcnetsdk().NET_DVR_CloseUpgradeHandle(upgradeHandle);
                }
                return response;
            }
        });
        new Thread(future).start();
        UpgradeAsyncResponse response = new UpgradeAsyncResponse();
        response.setHandle(upgradeHandle.longValue());
        response.setFuture(future);
        return HikResult.ok(response);
    }

    @Override
    public HikResult<String> getConfig() {
        HCNetSDK.NET_DVR_STRING_POINTER out = new HCNetSDK.NET_DVR_STRING_POINTER();
        out.byString = new byte[0xA00000];
        out.write();
        IntByReference returnSize = new IntByReference();
        boolean result = this.getHcnetsdk().NET_DVR_GetConfigFile_V30(this.userId, out.getPointer(), out.byString.length, returnSize);
        if (!result) {
            return this.lastError();
        }
        out.read();
        return HikResult.ok();
    }

    @Override
    public HikResult<?> getConfigFile(String file) {
        boolean result = this.getHcnetsdk().NET_DVR_GetConfigFile(this.userId, file);
        if (!result) {
            return this.lastError();
        }
        return HikResult.ok();
    }

    @Override
    public HikResult<?> setConfig(String configContent) {
        boolean result = this.getHcnetsdk().NET_DVR_SetConfigFile_EX(this.userId, configContent, configContent.getBytes().length);
        if (!result) {
            this.lastError();
        }
        return HikResult.ok();
    }

    @Override
    public HikResult<?> setConfigFile(String file) {
        boolean result = this.getHcnetsdk().NET_DVR_SetConfigFile(this.userId, file);
        if (!result) {
            return this.lastError();
        }
        return HikResult.ok();
    }

    @Override
    public HikResult<?> remoteControl(int command, Pointer inBuffer, int inBufferSize) {
        boolean result = this.getHcnetsdk().NET_DVR_RemoteControl(this.userId, command, inBuffer, inBufferSize);
        if (!result) {
            return this.lastError();
        }
        return HikResult.ok();
    }
}

