/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.options;

import com.github.lkqm.hcnet.HCNetSDK;
import com.github.lkqm.hcnet.HikDeviceTemplate;
import com.github.lkqm.hcnet.HikResult;
import com.github.lkqm.hcnet.options.BaseOptions;
import com.github.lkqm.hcnet.options.SdkOptions;

public class SdkOptionsImpl
extends BaseOptions
implements SdkOptions {
    public SdkOptionsImpl(HikDeviceTemplate deviceTemplate) {
        super(deviceTemplate);
    }

    @Override
    public String getVersion() {
        int buildVersion = this.getHcnetsdk().NET_DVR_GetSDKBuildVersion();
        return (buildVersion >> 24) + "." + (buildVersion << 8 >> 24) + "." + (buildVersion << 16 >> 16);
    }

    @Override
    public HikResult<HCNetSDK.NET_DVR_SDKSTATE> getState() {
        HCNetSDK.NET_DVR_SDKSTATE sdkState = new HCNetSDK.NET_DVR_SDKSTATE();
        boolean result = this.getHcnetsdk().NET_DVR_GetSDKState(sdkState);
        if (!result) {
            return this.lastError();
        }
        sdkState.read();
        return HikResult.ok(sdkState);
    }

    @Override
    public HikResult<HCNetSDK.NET_DVR_SDKABL> getAbility() {
        HCNetSDK.NET_DVR_SDKABL ability = new HCNetSDK.NET_DVR_SDKABL();
        boolean result = this.getHcnetsdk().NET_DVR_GetSDKAbility(ability);
        if (!result) {
            return this.lastError();
        }
        return HikResult.ok(ability);
    }

    @Override
    public HikResult<?> setLogFile(int logLevel, String logDir, boolean autoDel) {
        boolean result = this.getHcnetsdk().NET_DVR_SetLogToFile(logLevel, logDir, autoDel);
        if (!result) {
            return this.lastError();
        }
        return HikResult.ok();
    }

    @Override
    public HikResult<?> setTimeout(int connectTimeoutMs, int recvTimeoutMs, int reconnectIntervalMs) {
        boolean result = this.getHcnetsdk().NET_DVR_SetConnectTime(connectTimeoutMs, 3);
        if (!result) {
            return this.lastError();
        }
        result = this.getHcnetsdk().NET_DVR_SetRecvTimeOut(recvTimeoutMs);
        if (!result) {
            return this.lastError();
        }
        result = this.getHcnetsdk().NET_DVR_SetReconnect(reconnectIntervalMs, reconnectIntervalMs > 0);
        if (!result) {
            return this.lastError();
        }
        return HikResult.ok();
    }
}

