/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InnerUtils {
    public static long hikAbsTimeToTimestamp(int absTime) {
        int year = (absTime >> 26) + 2000;
        int month = (absTime >> 22 & 0xF) - 1;
        int day = absTime >> 17 & 0x1F;
        int hour = absTime >> 12 & 0x1F;
        int minute = absTime >> 6 & 0x3F;
        int second = absTime & 0x3F;
        Calendar result = Calendar.getInstance(TimeZone.getDefault());
        result.set(1, year);
        result.set(2, month);
        result.set(5, day);
        result.set(11, hour);
        result.set(12, minute);
        result.set(13, second);
        return result.getTimeInMillis();
    }

    public static boolean makeParentDirExists(File file) {
        File parentDir = file.getParentFile();
        if (!parentDir.exists()) {
            return parentDir.mkdirs();
        }
        return true;
    }

    public static void writeFile(byte[] bytes, String path) {
        File file = new File(path);
        InnerUtils.makeParentDirExists(file);
        try (FileOutputStream fos = new FileOutputStream(file, true);){
            fos.write(bytes);
            fos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Map<String, String> xmlToFlatMap(String xml, String rootElement) {
        HashMap<String, String> map = new HashMap<String, String>();
        Document doc = InnerUtils.parseXmlString(xml);
        NodeList rootNode = doc.getElementsByTagName(rootElement);
        if (rootNode == null || rootNode.getLength() == 0) {
            return map;
        }
        Node root = rootNode.item(0);
        NodeList nodes = root.getChildNodes();
        if (nodes == null) {
            return map;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            map.put(node.getNodeName(), node.getTextContent());
        }
        return map;
    }

    private static Document parseXmlString(String xmlStr) throws ParserConfigurationException, IOException, SAXException {
        InputSource is = new InputSource(new StringReader(xmlStr));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(is);
        return doc;
    }
}

