/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback.adapter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingCallable;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class AdapterThrowingRunnableToCallable<DATATYPE, EXTYPE extends Exception>
implements IThrowingCallable<DATATYPE, EXTYPE> {
    private final IThrowingRunnable<EXTYPE> m_aRunnable;
    private final DATATYPE m_aResult;

    public AdapterThrowingRunnableToCallable(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) {
        this(iThrowingRunnable, null);
    }

    public AdapterThrowingRunnableToCallable(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable, @Nullable DATATYPE DATATYPE) {
        this.m_aRunnable = ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        this.m_aResult = DATATYPE;
    }

    @Nonnull
    public IThrowingRunnable<EXTYPE> getRunnable() {
        return this.m_aRunnable;
    }

    @Nullable
    public DATATYPE getResult() {
        return this.m_aResult;
    }

    @Override
    @Nullable
    public DATATYPE call() throws EXTYPE {
        this.m_aRunnable.run();
        return this.m_aResult;
    }

    public String toString() {
        return new ToStringGenerator(this).append("runnable", this.m_aRunnable).append("result", this.m_aResult).toString();
    }

    @Nonnull
    public static <EXTYPE extends Exception> AdapterThrowingRunnableToCallable<Object, EXTYPE> createAdapter(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) {
        return new AdapterThrowingRunnableToCallable(iThrowingRunnable);
    }

    @Nonnull
    public static <DATATYPE, EXTYPE extends Exception> AdapterThrowingRunnableToCallable<DATATYPE, EXTYPE> createAdapter(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable, @Nullable DATATYPE DATATYPE) {
        return new AdapterThrowingRunnableToCallable<DATATYPE, EXTYPE>(iThrowingRunnable, DATATYPE);
    }
}

