/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.codec.AbstractByteArrayCodec;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import java.util.BitSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class QuotedPrintableCodec
extends AbstractByteArrayCodec {
    private static final byte ESCAPE_CHAR = 61;
    private static final byte TAB = 9;
    private static final byte SPACE = 32;
    private static final BitSet PRINTABLE_CHARS = new BitSet(256);

    @Nonnull
    @ReturnsMutableCopy
    public static BitSet getDefaultBitSet() {
        return (BitSet)PRINTABLE_CHARS.clone();
    }

    public static final void writeEncodeQuotedPrintableByte(int n, @Nonnull NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream) {
        char c = StringHelper.getHexCharUpperCase(n >> 4 & 0xF);
        char c2 = StringHelper.getHexCharUpperCase(n & 0xF);
        nonBlockingByteArrayOutputStream.write(61);
        nonBlockingByteArrayOutputStream.write(c);
        nonBlockingByteArrayOutputStream.write(c2);
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getEncodedQuotedPrintable(@Nonnull BitSet bitSet, @Nullable byte[] byArray) {
        ValueEnforcer.notNull(bitSet, "PrintableBitSet");
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(byArray.length * 2);
        for (byte by : byArray) {
            int n = by & 0xFF;
            if (bitSet.get(n)) {
                nonBlockingByteArrayOutputStream.write(n);
                continue;
            }
            QuotedPrintableCodec.writeEncodeQuotedPrintableByte(n, nonBlockingByteArrayOutputStream);
        }
        return nonBlockingByteArrayOutputStream.toByteArray();
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getEncodedQuotedPrintable(@Nullable byte[] byArray) {
        return QuotedPrintableCodec.getEncodedQuotedPrintable(PRINTABLE_CHARS, byArray);
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getEncoded(@Nullable byte[] byArray) {
        return QuotedPrintableCodec.getEncodedQuotedPrintable(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @ReturnsMutableCopy
    public static byte[] getDecodedQuotedPrintable(@Nullable byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
        try {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte by = byArray[i];
                if (by == 61) {
                    char c;
                    int n2;
                    if (i >= n - 2) {
                        throw new DecodeException("Invalid quoted-printable encoding. Premature of string after escape char");
                    }
                    ++i;
                    char c2 = (char)byArray[i];
                    if ((n2 = StringHelper.getHexByte(c2, c = (char)byArray[++i])) < 0) {
                        throw new DecodeException("Invalid quoted-printable encoding for " + c2 + c);
                    }
                    nonBlockingByteArrayOutputStream.write(n2);
                    continue;
                }
                nonBlockingByteArrayOutputStream.write(by);
            }
            byte[] byArray2 = nonBlockingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            StreamHelper.close(nonBlockingByteArrayOutputStream);
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public static byte[] getDecodedQuotedPrintable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return QuotedPrintableCodec.getDecodedQuotedPrintable(CharsetManager.getAsBytes(string, CCharset.CHARSET_US_ASCII_OBJ));
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public byte[] getDecoded(@Nullable byte[] byArray) {
        return QuotedPrintableCodec.getDecodedQuotedPrintable(byArray);
    }

    @Nullable
    public static String getEncodedQuotedPrintableString(@Nonnull BitSet bitSet, @Nonnull byte[] byArray) {
        byte[] byArray2 = QuotedPrintableCodec.getEncodedQuotedPrintable(bitSet, byArray);
        return byArray2 == null ? null : CharsetManager.getAsString(byArray2, CCharset.CHARSET_US_ASCII_OBJ);
    }

    @Nullable
    public static String getEncodedQuotedPrintableString(@Nonnull byte[] byArray) {
        return QuotedPrintableCodec.getEncodedQuotedPrintableString(PRINTABLE_CHARS, byArray);
    }

    @Nullable
    public static String getEncodedQuotedPrintableString(@Nonnull BitSet bitSet, @Nullable String string, @Nonnull Charset charset) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        return QuotedPrintableCodec.getEncodedQuotedPrintableString(bitSet, CharsetManager.getAsBytes(string, charset));
    }

    @Nullable
    public static String getEncodedQuotedPrintableString(@Nullable String string, @Nonnull Charset charset) {
        return QuotedPrintableCodec.getEncodedQuotedPrintableString(PRINTABLE_CHARS, string, charset);
    }

    @Nullable
    public static String getDecodedQuotedPrintableString(@Nullable String string, @Nonnull Charset charset) {
        if (StringHelper.hasNoText(string)) {
            return string;
        }
        return CharsetManager.getAsString(QuotedPrintableCodec.getDecodedQuotedPrintable(string), charset);
    }

    static {
        PRINTABLE_CHARS.set(9);
        PRINTABLE_CHARS.set(32);
        for (int i = 33; i <= 126; ++i) {
            if (i == 61) continue;
            PRINTABLE_CHARS.set(i);
        }
    }
}

