/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.convert.IConverter;
import com.helger.commons.filter.IFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContainerConversionHelper {
    private static final ContainerConversionHelper s_aInstance = new ContainerConversionHelper();

    private ContainerConversionHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        HashSet<DSTTYPE> hashSet = new HashSet<DSTTYPE>();
        while (iterator.hasNext()) {
            hashSet.add(iConverter.convert(iterator.next()));
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        HashSet<DSTTYPE> hashSet = new HashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            hashSet.add(iConverter.convert(SRCTYPE));
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        HashSet<DSTTYPE> hashSet = new HashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            if (!iFilter.matchesFilter(SRCTYPE)) continue;
            hashSet.add(iConverter.convert(SRCTYPE));
        }
        return hashSet;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newSet(iterator, iConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newSet(iterable, iConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newSet(iterable, iFilter, iConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        LinkedHashSet<DSTTYPE> linkedHashSet = new LinkedHashSet<DSTTYPE>();
        while (iterator.hasNext()) {
            linkedHashSet.add(iConverter.convert(iterator.next()));
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        LinkedHashSet<DSTTYPE> linkedHashSet = new LinkedHashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            linkedHashSet.add(iConverter.convert(SRCTYPE));
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        LinkedHashSet<DSTTYPE> linkedHashSet = new LinkedHashSet<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            if (!iFilter.matchesFilter(SRCTYPE)) continue;
            linkedHashSet.add(iConverter.convert(SRCTYPE));
        }
        return linkedHashSet;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(iterator, iConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(iterable, iConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> Set<DSTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newOrderedSet(iterable, iFilter, iConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                arrayList.add(iConverter.convert(SRCTYPE));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>(ArrayHelper.getSize(SRCTYPEArray));
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                arrayList.add(iConverter.convert(SRCTYPE));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                if (!iFilter.matchesFilter(SRCTYPE)) continue;
                arrayList.add(iConverter.convert(SRCTYPE));
            }
        }
        return arrayList;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newList(iterable, iConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newList(SRCTYPEArray, iConverter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> newUnmodifiableList(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull IFilter<? super SRCTYPE> iFilter, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        return CollectionHelper.makeUnmodifiable(ContainerConversionHelper.newList(iterable, iFilter, iConverter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> List<DSTTYPE> getSorted(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        ValueEnforcer.notNull(iterator, "Iterator");
        ValueEnforcer.notNull(iConverter, "Converter");
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        while (iterator.hasNext()) {
            arrayList.add(iConverter.convert(iterator.next()));
        }
        return CollectionHelper.getSortedInline(arrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> getSorted(@Nonnull Iterator<? extends SRCTYPE> iterator, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter, @Nonnull Comparator<? super DSTTYPE> comparator) {
        ValueEnforcer.notNull(iterator, "Iterator");
        ValueEnforcer.notNull(iConverter, "Converter");
        ValueEnforcer.notNull(comparator, "Comparator");
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        while (iterator.hasNext()) {
            arrayList.add(iConverter.convert(iterator.next()));
        }
        return CollectionHelper.getSortedInline(arrayList, comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE extends Comparable<? super DSTTYPE>> List<DSTTYPE> getSorted(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        ValueEnforcer.notNull(iterable, "Container");
        ValueEnforcer.notNull(iConverter, "Converter");
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            arrayList.add(iConverter.convert(SRCTYPE));
        }
        return CollectionHelper.getSortedInline(arrayList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> List<DSTTYPE> getSorted(@Nonnull Iterable<? extends SRCTYPE> iterable, @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter, @Nonnull Comparator<? super DSTTYPE> comparator) {
        ValueEnforcer.notNull(iterable, "Container");
        ValueEnforcer.notNull(iConverter, "Converter");
        ValueEnforcer.notNull(comparator, "Comparator");
        ArrayList<DSTTYPE> arrayList = new ArrayList<DSTTYPE>();
        for (SRCTYPE SRCTYPE : iterable) {
            arrayList.add(iConverter.convert(SRCTYPE));
        }
        return CollectionHelper.getSortedInline(arrayList, comparator);
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> Iterator<DSTTYPE> getIterator(final @Nonnull Iterable<SRCTYPE> iterable, final @Nonnull IConverter<? super SRCTYPE, ? extends DSTTYPE> iConverter) {
        ValueEnforcer.notNull(iterable, "Container");
        ValueEnforcer.notNull(iConverter, "Converter");
        return new Iterator<DSTTYPE>(){
            private final Iterator<SRCTYPE> m_aIT;
            {
                this.m_aIT = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.m_aIT.hasNext();
            }

            @Override
            public DSTTYPE next() {
                return iConverter.convert(this.m_aIT.next());
            }

            @Override
            public void remove() {
                this.m_aIT.remove();
            }
        };
    }
}

