/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.INonThrowingCallable;
import com.helger.commons.callback.IThrowingCallable;
import com.helger.commons.callback.IThrowingRunnable;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleReadWriteLock
implements ReadWriteLock,
Serializable {
    private final ReentrantReadWriteLock m_aRWLock;

    public SimpleReadWriteLock() {
        this.m_aRWLock = new ReentrantReadWriteLock();
    }

    public SimpleReadWriteLock(boolean bl) {
        this.m_aRWLock = new ReentrantReadWriteLock(bl);
    }

    @Override
    @Nonnull
    public Lock readLock() {
        return this.m_aRWLock.readLock();
    }

    @Override
    @Nonnull
    public Lock writeLock() {
        return this.m_aRWLock.writeLock();
    }

    public void readLocked(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        this.m_aRWLock.readLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public <EXTYPE extends Exception> void readLockedThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        this.m_aRWLock.readLock().lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    public <T> T readLocked(@Nonnull INonThrowingCallable<T> iNonThrowingCallable) {
        ValueEnforcer.notNull(iNonThrowingCallable, "Callable");
        this.m_aRWLock.readLock().lock();
        try {
            T t = iNonThrowingCallable.call();
            return t;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Nullable
    public <T, EXTYPE extends Exception> T readLockedThrowing(@Nonnull IThrowingCallable<T, EXTYPE> iThrowingCallable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingCallable, "Callable");
        this.m_aRWLock.readLock().lock();
        try {
            T t = iThrowingCallable.call();
            return t;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    public void writeLocked(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        this.m_aRWLock.writeLock().lock();
        try {
            runnable.run();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    public <EXTYPE extends Exception> void writeLockedThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        this.m_aRWLock.writeLock().lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public <T> T writeLocked(@Nonnull INonThrowingCallable<T> iNonThrowingCallable) {
        ValueEnforcer.notNull(iNonThrowingCallable, "Callable");
        this.m_aRWLock.writeLock().lock();
        try {
            T t = iNonThrowingCallable.call();
            return t;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public <T, EXTYPE extends Exception> T writeLockedThrowing(@Nonnull IThrowingCallable<T, EXTYPE> iThrowingCallable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingCallable, "Callable");
        this.m_aRWLock.writeLock().lock();
        try {
            T t = iThrowingCallable.call();
            return t;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }
}

