/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.deadlock;

import com.helger.commons.deadlock.IThreadDeadlockCallback;
import com.helger.commons.deadlock.ThreadDeadlockInfo;
import com.helger.commons.lang.StackTraceHelper;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingThreadDeadlockCallback
implements IThreadDeadlockCallback {
    private static final Logger s_aLogger = LoggerFactory.getLogger(LoggingThreadDeadlockCallback.class);

    @Override
    public void onDeadlockDetected(@Nonnull ThreadDeadlockInfo[] threadDeadlockInfoArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(threadDeadlockInfoArray.length).append(" deadlocked threads:\n");
        for (ThreadDeadlockInfo threadDeadlockInfo : threadDeadlockInfoArray) {
            Thread thread = threadDeadlockInfo.getThread();
            stringBuilder.append('\n').append(thread.toString()).append(":\n").append(StackTraceHelper.getStackAsString(thread.getStackTrace()));
        }
        s_aLogger.error(stringBuilder.toString());
    }
}

