/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.scope.AbstractMapBasedScope;
import com.helger.commons.scope.IRequestScope;
import com.helger.commons.scope.ScopeHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestScope
extends AbstractMapBasedScope
implements IRequestScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(RequestScope.class);
    private final String m_sSessionID;

    public RequestScope(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        super(string);
        this.m_sSessionID = ValueEnforcer.notEmpty(string2, "SessionID");
        if (ScopeHelper.debugRequestScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created request scope '" + string + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getSessionID() {
        return this.getSessionID(true);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getSessionID(boolean bl) {
        return this.m_sSessionID;
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.debugRequestScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying request scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.debugRequestScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed request scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    @Nullable
    public List<String> getAttributeAsList(@Nullable String string) {
        return this.getAttributeAsList(string, null);
    }

    @Nullable
    @OverrideOnDemand
    protected List<String> getAttributeAsListCustom(@Nullable String string, @Nonnull Object object, @Nullable List<String> list) {
        return list;
    }

    @Override
    @Nullable
    public List<String> getAttributeAsList(@Nullable String string, @Nullable List<String> list) {
        Object VALUETYPE = this.getAttributeObject(string);
        if (VALUETYPE == null) {
            return null;
        }
        if (VALUETYPE instanceof String[]) {
            return CollectionHelper.newList((String[])VALUETYPE);
        }
        if (VALUETYPE instanceof String) {
            return CollectionHelper.newList((String)VALUETYPE);
        }
        return this.getAttributeAsListCustom(string, VALUETYPE, list);
    }

    @Override
    public boolean hasAttributeValue(@Nullable String string, @Nullable String string2) {
        return EqualsHelper.equals(this.getAttributeAsString(string), string2);
    }

    @Override
    public boolean hasAttributeValue(@Nullable String string, @Nullable String string2, boolean bl) {
        String string3 = this.getAttributeAsString(string);
        return string3 == null ? bl : EqualsHelper.equals(string3, string2);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("sessionID", this.m_sSessionID).toString();
    }
}

