/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.services.internal.utils.AccessLoggerUtils;
import com.obs.services.internal.utils.ServiceUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogConfigurator {
    public static final Level OFF = Level.parse("OFF");
    public static final Level TRACE = Level.parse("FINEST");
    public static final Level DEBUG = Level.parse("FINE");
    public static final Level INFO = Level.parse("INFO");
    public static final Level WARN = Level.parse("WARNING");
    public static final Level ERROR = Level.parse("SEVERE");
    private static final Logger logger = Logger.getLogger("com.obs");
    private static final Logger accessLogger = Logger.getLogger("com.obs.log.AccessLogger");
    private static Level logLevel;
    private static String logFileDir;
    private static int logFileSize;
    private static int logFileRolloverCount;
    private static volatile boolean logEnabled;
    private static volatile boolean accessLogEnabled;

    private static String getDefaultLogFileDir() {
        try {
            Class<?> c = Class.forName("android.os.Environment");
            Method m = c.getMethod("getExternalStorageDirectory", new Class[0]);
            if (m != null) {
                return m.invoke(c, new Object[0]).toString() + "/logs";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return System.getProperty("user.dir") + "/logs";
    }

    private static void logOn(final Logger pLogger, String logName) {
        pLogger.setUseParentHandlers(false);
        pLogger.setLevel(logLevel == null ? WARN : logLevel);
        if (logFileDir == null) {
            logFileDir = LogConfigurator.getDefaultLogFileDir();
        }
        try {
            File dir = new File(logFileDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileHandler fh = new FileHandler(logFileDir + logName, logFileSize, logFileRolloverCount, true);
            fh.setEncoding("UTF-8");
            fh.setFormatter(new Formatter(){

                public String format(LogRecord record) {
                    String levelName = record.getLevel().getName();
                    if ("SEVERE".equals(levelName)) {
                        levelName = "ERROR";
                    } else if ("FINE".equals(levelName)) {
                        levelName = "DEBUG";
                    } else if ("FINEST".equals(levelName)) {
                        levelName = "TRACE";
                    }
                    if (pLogger == accessLogger) {
                        return Thread.currentThread().getName() + "\n" + record.getMessage() + (record.getThrown() == null ? "" : record.getThrown()) + System.getProperty("line.separator");
                    }
                    Date d = new Date(record.getMillis());
                    SimpleDateFormat format = AccessLoggerUtils.getFormat();
                    return format.format(d) + "|" + Thread.currentThread().getName() + "|" + levelName + " |" + record.getMessage() + (record.getThrown() == null ? "" : record.getThrown()) + System.getProperty("line.separator");
                }
            });
            pLogger.addHandler(fh);
            if (pLogger == accessLogger) {
                accessLogEnabled = true;
            } else if (pLogger == logger) {
                logEnabled = true;
            }
        }
        catch (Exception e) {
            try {
                Class<?> c = Class.forName("android.util.Log");
                try {
                    Method m = c.getMethod("i", String.class, String.class, Throwable.class);
                    m.invoke(null, "OBS Android SDK", "Enable SDK log failed", e);
                }
                catch (Exception ex) {
                    Method m = c.getMethod("i", String.class, String.class);
                    m.invoke(null, "OBS Android SDK", "Enable SDK log failed" + e.getMessage());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LogConfigurator.logOff(pLogger);
        }
    }

    private static void logOff(Logger pLogger) {
        pLogger.setLevel(OFF);
        Handler[] handlers = pLogger.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                pLogger.removeHandler(handler);
            }
        }
        if (pLogger == accessLogger) {
            accessLogEnabled = false;
        } else if (pLogger == logger) {
            logEnabled = false;
        }
    }

    public static synchronized void enableLog() {
        if (logEnabled) {
            LogConfigurator.logOff(logger);
        }
        LogConfigurator.logOn(logger, "/OBS-SDK.log");
    }

    protected static synchronized void disableLog() {
        LogConfigurator.logOff(logger);
    }

    public static synchronized void enableAccessLog() {
        if (accessLogEnabled) {
            LogConfigurator.logOff(accessLogger);
        }
        LogConfigurator.logOn(accessLogger, "/OBS-SDK-access.log");
    }

    protected static synchronized void disableAccessLog() {
        LogConfigurator.logOff(accessLogger);
    }

    public static synchronized void setLogLevel(Level level) {
        if (level != null) {
            logLevel = level;
        }
    }

    public static synchronized void setLogFileRolloverCount(int count) {
        if (count > 0) {
            logFileRolloverCount = count;
        }
    }

    public static synchronized void setLogFileSize(int fileSize) {
        if (fileSize >= 0) {
            logFileSize = fileSize;
        }
    }

    public static synchronized void setLogFileDir(String dir) {
        if (ServiceUtils.isValid(dir)) {
            logFileDir = dir;
        }
    }

    static {
        LogConfigurator.disableLog();
        LogConfigurator.disableAccessLog();
        logFileSize = 0x1E00000;
        logFileRolloverCount = 50;
        logEnabled = false;
        accessLogEnabled = false;
    }
}

