/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.services.internal.DefaultProgressStatus;
import com.obs.services.internal.ProgressManager;
import com.obs.services.model.ProgressListener;
import java.util.Date;
import java.util.List;

public class SimpleProgressManager
extends ProgressManager {
    protected long transferredBytes;
    protected long newlyTransferredBytes;

    public SimpleProgressManager(long totalBytes, long transferredBytes, ProgressListener progressListener, long intervalBytes) {
        super(totalBytes, progressListener, intervalBytes);
        this.transferredBytes = transferredBytes < 0L ? 0L : transferredBytes;
    }

    protected void doProgressChanged(int bytes) {
        List<ProgressManager.BytesUnit> currentInstantaneousBytes;
        this.transferredBytes += (long)bytes;
        this.newlyTransferredBytes += (long)bytes;
        Date now = new Date();
        this.lastInstantaneousBytes = currentInstantaneousBytes = this.createCurrentInstantaneousBytes(bytes, now);
        if (this.newlyTransferredBytes >= this.intervalBytes && (this.transferredBytes < this.totalBytes || this.totalBytes == -1L)) {
            DefaultProgressStatus status = new DefaultProgressStatus(this.newlyTransferredBytes, this.transferredBytes, this.totalBytes, now.getTime() - this.lastCheckpoint.getTime(), now.getTime() - this.startCheckpoint.getTime());
            status.setInstantaneousBytes(currentInstantaneousBytes);
            this.progressListener.progressChanged(status);
            this.newlyTransferredBytes = 0L;
            this.lastCheckpoint = now;
        }
    }

    public void progressEnd() {
        if (this.progressListener == null) {
            return;
        }
        Date now = new Date();
        DefaultProgressStatus status = new DefaultProgressStatus(this.newlyTransferredBytes, this.transferredBytes, this.totalBytes, now.getTime() - this.lastCheckpoint.getTime(), now.getTime() - this.startCheckpoint.getTime());
        this.progressListener.progressChanged(status);
    }
}

