/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.HeaderResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BucketLoggingConfiguration
extends HeaderResponse {
    private String targetBucketName;
    private String logfilePrefix;
    private String agency;
    private final List<GrantAndPermission> targetGrantsList = new ArrayList<GrantAndPermission>();

    public BucketLoggingConfiguration() {
    }

    public BucketLoggingConfiguration(String targetBucketName, String logfilePrefix) {
        this.targetBucketName = targetBucketName;
        this.logfilePrefix = logfilePrefix;
    }

    public String getTargetBucketName() {
        return this.targetBucketName;
    }

    public void setTargetBucketName(String targetBucketName) {
        this.targetBucketName = targetBucketName;
    }

    public String getLogfilePrefix() {
        return this.logfilePrefix;
    }

    public void setLogfilePrefix(String logfilePrefix) {
        this.logfilePrefix = logfilePrefix;
    }

    public GrantAndPermission[] getTargetGrants() {
        return this.targetGrantsList.toArray(new GrantAndPermission[this.targetGrantsList.size()]);
    }

    public void setTargetGrants(GrantAndPermission[] targetGrants) {
        this.targetGrantsList.clear();
        this.targetGrantsList.addAll(Arrays.asList(targetGrants));
    }

    public void addTargetGrant(GrantAndPermission targetGrant) {
        this.targetGrantsList.add(targetGrant);
    }

    public boolean isLoggingEnabled() {
        return this.targetBucketName != null || this.logfilePrefix != null || this.targetGrantsList.size() > 0;
    }

    public String getAgency() {
        return this.agency;
    }

    public void setAgency(String agency) {
        this.agency = agency;
    }

    public String toString() {
        return "BucketLoggingConfiguration [targetBucketName=" + this.targetBucketName + ", logfilePrefix=" + this.logfilePrefix + ", agency=" + this.agency + ", targetGrantsList=" + this.targetGrantsList + "]";
    }
}

