/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields.borders;

import com.itextpdf.forms.fields.borders.AbstractFormBorder;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.SolidBorder;

class BeveledBorder
extends AbstractFormBorder {
    private final Color backgroundColor;

    public BeveledBorder(Color color, float width, Color backgroundColor) {
        super(color, width);
        this.backgroundColor = backgroundColor;
    }

    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        Color darkerBackground;
        SolidBorder solidBorder = new SolidBorder(this.getColor(), this.width);
        solidBorder.draw(canvas, x1, y1, x2, y2, defaultSide, borderWidthBefore, borderWidthAfter);
        float borderWidth = this.getWidth();
        float borderWidthX2 = borderWidth + borderWidth;
        Color color = darkerBackground = this.backgroundColor != null ? this.getDarkerColor(this.backgroundColor) : ColorConstants.LIGHT_GRAY;
        if (Border.Side.TOP.equals((Object)defaultSide)) {
            solidBorder = new SolidBorder(ColorConstants.WHITE, borderWidth);
            solidBorder.draw(canvas, borderWidthX2, y1 - borderWidth, x2 - borderWidth, y2 - borderWidth, Border.Side.TOP, borderWidth, borderWidth);
        } else if (Border.Side.BOTTOM.equals((Object)defaultSide)) {
            solidBorder = new SolidBorder(darkerBackground, borderWidth);
            solidBorder.draw(canvas, x1 - borderWidth, borderWidthX2, borderWidthX2, borderWidthX2, Border.Side.BOTTOM, borderWidth, borderWidth);
        } else if (Border.Side.LEFT.equals((Object)defaultSide)) {
            solidBorder = new SolidBorder(ColorConstants.WHITE, borderWidth);
            solidBorder.draw(canvas, borderWidthX2, borderWidthX2, borderWidthX2, y2 - borderWidth, Border.Side.LEFT, borderWidth, borderWidth);
        } else if (Border.Side.RIGHT.equals((Object)defaultSide)) {
            solidBorder = new SolidBorder(darkerBackground, borderWidth);
            solidBorder.draw(canvas, x1 - borderWidth, y1 - borderWidth, x2 - borderWidth, borderWidthX2, Border.Side.RIGHT, borderWidth, borderWidth);
        }
    }

    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide) {
        throw new UnsupportedOperationException();
    }

    public int getType() {
        return 1002;
    }

    private Color getDarkerColor(Color color) {
        if (color instanceof DeviceRgb) {
            return DeviceRgb.makeDarker((DeviceRgb)((DeviceRgb)color));
        }
        if (color instanceof DeviceCmyk) {
            return DeviceCmyk.makeDarker((DeviceCmyk)((DeviceCmyk)color));
        }
        if (color instanceof DeviceGray) {
            return DeviceGray.makeDarker((DeviceGray)((DeviceGray)color));
        }
        return color;
    }
}

