/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.xfdf.AnnotObject;
import com.itextpdf.forms.xfdf.AnnotsObject;
import com.itextpdf.forms.xfdf.FieldObject;
import com.itextpdf.forms.xfdf.FieldsObject;
import com.itextpdf.forms.xfdf.XfdfObject;
import com.itextpdf.forms.xfdf.XfdfObjectUtils;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfCircleAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfFreeTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPolyGeomAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfSquareAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfStampAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextMarkupAnnotation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XfdfReader {
    private static Logger logger = LoggerFactory.getLogger(XfdfReader.class);

    XfdfReader() {
    }

    void mergeXfdfIntoPdf(XfdfObject xfdfObject, PdfDocument pdfDocument, String pdfDocumentName) {
        if (xfdfObject.getF() != null && xfdfObject.getF().getHref() != null) {
            if (pdfDocumentName.equalsIgnoreCase(xfdfObject.getF().getHref())) {
                logger.info("Xfdf href and pdf name are equal. Continue merge");
            } else {
                logger.warn("Xfdf href attribute and pdf document name are different!");
            }
        } else {
            logger.warn("Xfdf no f object to compare.");
        }
        PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDocument, false);
        if (form != null) {
            this.mergeFields(xfdfObject.getFields(), form);
            this.mergeAnnotations(xfdfObject.getAnnots(), pdfDocument);
        }
    }

    private void mergeFields(FieldsObject fieldsObject, PdfAcroForm form) {
        if (fieldsObject != null && fieldsObject.getFieldList() != null && !fieldsObject.getFieldList().isEmpty()) {
            Map<String, PdfFormField> formFields = form.getFormFields();
            for (FieldObject xfdfField : fieldsObject.getFieldList()) {
                String name = xfdfField.getName();
                if (formFields.get(name) != null && xfdfField.getValue() != null) {
                    formFields.get(name).setValue(xfdfField.getValue());
                    continue;
                }
                logger.error("Xfdf no such field in pdf document!");
            }
        }
    }

    private void mergeAnnotations(AnnotsObject annotsObject, PdfDocument pdfDocument) {
        List<AnnotObject> annotList = null;
        if (annotsObject != null) {
            annotList = annotsObject.getAnnotsList();
        }
        if (annotList != null && !annotList.isEmpty()) {
            for (AnnotObject annot : annotList) {
                this.addAnnotationToPdf(annot, pdfDocument);
            }
        }
    }

    private void addCommonAnnotationAttributes(PdfAnnotation annotation, AnnotObject annotObject) {
        annotation.setFlags(XfdfObjectUtils.convertFlagsFromString(annotObject.getAttributeValue("flags")));
        annotation.setColor(XfdfObjectUtils.convertColorFloatsFromString(annotObject.getAttributeValue("color")));
        annotation.setDate(new PdfString(annotObject.getAttributeValue("date")));
        annotation.setName(new PdfString(annotObject.getAttributeValue("name")));
        annotation.setTitle(new PdfString(annotObject.getAttributeValue("title")));
    }

    private void addMarkupAnnotationAttributes(PdfMarkupAnnotation annotation, AnnotObject annotObject) {
        annotation.setCreationDate(new PdfString(annotObject.getAttributeValue("creationdate")));
        annotation.setSubject(new PdfString(annotObject.getAttributeValue("subject")));
    }

    private void addAnnotationToPdf(AnnotObject annotObject, PdfDocument pdfDocument) {
        String annotName = annotObject.getName();
        if (annotName != null) {
            switch (annotName) {
                case "text": {
                    PdfTextAnnotation pdfTextAnnotation = new PdfTextAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfTextAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfTextAnnotation, annotObject);
                    pdfTextAnnotation.setIconName(new PdfName(annotObject.getAttributeValue("icon")));
                    if (annotObject.getAttributeValue("state") != null) {
                        pdfTextAnnotation.setState(new PdfString(annotObject.getAttributeValue("state")));
                    }
                    if (annotObject.getAttributeValue("statemodel") != null) {
                        pdfTextAnnotation.setStateModel(new PdfString(annotObject.getAttributeValue("statemodel")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttributeValue("page"))).addAnnotation((PdfAnnotation)pdfTextAnnotation);
                    break;
                }
                case "highlight": {
                    PdfTextMarkupAnnotation pdfHighLightAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.Highlight, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfHighLightAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfHighLightAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfHighLightAnnotation);
                    break;
                }
                case "underline": {
                    PdfTextMarkupAnnotation pdfUnderlineAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.Underline, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfUnderlineAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfUnderlineAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfUnderlineAnnotation);
                    break;
                }
                case "strikeout": {
                    PdfTextMarkupAnnotation pdfStrikeoutAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.StrikeOut, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfStrikeoutAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfStrikeoutAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfStrikeoutAnnotation);
                    break;
                }
                case "squiggly": {
                    PdfTextMarkupAnnotation pdfSquigglyAnnotation = new PdfTextMarkupAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), PdfName.Squiggly, XfdfObjectUtils.convertQuadPointsFromCoordsString(annotObject.getAttributeValue("coords")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfSquigglyAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfSquigglyAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfSquigglyAnnotation);
                    break;
                }
                case "circle": {
                    PdfCircleAnnotation pdfCircleAnnotation = new PdfCircleAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfCircleAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfCircleAnnotation, annotObject);
                    if (annotObject.getAttributeValue("fringe") != null) {
                        pdfCircleAnnotation.setRectangleDifferences(XfdfObjectUtils.convertFringeFromString(annotObject.getAttributeValue("fringe")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfCircleAnnotation);
                    break;
                }
                case "square": {
                    PdfSquareAnnotation pdfSquareAnnotation = new PdfSquareAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")));
                    this.addCommonAnnotationAttributes((PdfAnnotation)pdfSquareAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)pdfSquareAnnotation, annotObject);
                    if (annotObject.getAttributeValue("fringe") != null) {
                        pdfSquareAnnotation.setRectangleDifferences(XfdfObjectUtils.convertFringeFromString(annotObject.getAttributeValue("fringe")));
                    }
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)pdfSquareAnnotation);
                    break;
                }
                case "polygon": {
                    Rectangle rect = XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect"));
                    float[] vertices = XfdfObjectUtils.convertVerticesFromString(annotObject.getVertices());
                    PdfPolyGeomAnnotation polygonAnnotation = PdfPolyGeomAnnotation.createPolygon((Rectangle)rect, (float[])vertices);
                    this.addCommonAnnotationAttributes((PdfAnnotation)polygonAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)polygonAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)polygonAnnotation);
                    break;
                }
                case "polyline": {
                    Rectangle polylineRect = XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect"));
                    float[] polylineVertices = XfdfObjectUtils.convertVerticesFromString(annotObject.getVertices());
                    PdfPolyGeomAnnotation polylineAnnotation = PdfPolyGeomAnnotation.createPolyLine((Rectangle)polylineRect, (float[])polylineVertices);
                    this.addCommonAnnotationAttributes((PdfAnnotation)polylineAnnotation, annotObject);
                    this.addMarkupAnnotationAttributes((PdfMarkupAnnotation)polylineAnnotation, annotObject);
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)polylineAnnotation);
                    break;
                }
                case "stamp": {
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)new PdfStampAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect"))));
                    break;
                }
                case "freetext": {
                    pdfDocument.getPage(Integer.parseInt(annotObject.getAttribute("page").getValue())).addAnnotation((PdfAnnotation)new PdfFreeTextAnnotation(XfdfObjectUtils.convertRectFromString(annotObject.getAttributeValue("rect")), annotObject.getContents()));
                    break;
                }
                default: {
                    logger.warn(MessageFormatUtil.format((String)"Xfdf annotation \"{0}\" is not supported", (Object[])new Object[]{annotName}));
                }
            }
        }
    }
}

