/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.image;

import com.itextpdf.io.IOException;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.util.UrlUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;

public final class ImageTypeDetector {
    private static final byte[] gif = new byte[]{71, 73, 70};
    private static final byte[] jpeg = new byte[]{-1, -40};
    private static final byte[] jpeg2000_1 = new byte[]{0, 0, 0, 12};
    private static final byte[] jpeg2000_2 = new byte[]{-1, 79, -1, 81};
    private static final byte[] png = new byte[]{-119, 80, 78, 71};
    private static final byte[] wmf = new byte[]{-41, -51};
    private static final byte[] bmp = new byte[]{66, 77};
    private static final byte[] tiff_1 = new byte[]{77, 77, 0, 42};
    private static final byte[] tiff_2 = new byte[]{73, 73, 42, 0};
    private static final byte[] jbig2 = new byte[]{-105, 74, 66, 50, 13, 10, 26, 10};

    private ImageTypeDetector() {
    }

    public static ImageType detectImageType(byte[] source) {
        byte[] header = ImageTypeDetector.readImageType(source);
        return ImageTypeDetector.detectImageTypeByHeader(header);
    }

    public static ImageType detectImageType(URL source) {
        byte[] header = ImageTypeDetector.readImageType(source);
        return ImageTypeDetector.detectImageTypeByHeader(header);
    }

    private static ImageType detectImageTypeByHeader(byte[] header) {
        if (ImageTypeDetector.imageTypeIs(header, gif)) {
            return ImageType.GIF;
        }
        if (ImageTypeDetector.imageTypeIs(header, jpeg)) {
            return ImageType.JPEG;
        }
        if (ImageTypeDetector.imageTypeIs(header, jpeg2000_1) || ImageTypeDetector.imageTypeIs(header, jpeg2000_2)) {
            return ImageType.JPEG2000;
        }
        if (ImageTypeDetector.imageTypeIs(header, png)) {
            return ImageType.PNG;
        }
        if (ImageTypeDetector.imageTypeIs(header, bmp)) {
            return ImageType.BMP;
        }
        if (ImageTypeDetector.imageTypeIs(header, tiff_1) || ImageTypeDetector.imageTypeIs(header, tiff_2)) {
            return ImageType.TIFF;
        }
        if (ImageTypeDetector.imageTypeIs(header, jbig2)) {
            return ImageType.JBIG2;
        }
        if (ImageTypeDetector.imageTypeIs(header, wmf)) {
            return ImageType.WMF;
        }
        return ImageType.NONE;
    }

    private static boolean imageTypeIs(byte[] imageType, byte[] compareWith) {
        for (int i = 0; i < compareWith.length; ++i) {
            if (imageType[i] == compareWith[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] readImageType(URL source) {
        try (InputStream stream = UrlUtil.openStream(source);){
            byte[] bytes = new byte[8];
            stream.read(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (java.io.IOException e) {
            throw new IOException("I/O exception.", e);
        }
    }

    private static byte[] readImageType(byte[] source) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(source);
            byte[] bytes = new byte[8];
            stream.read(bytes);
            return bytes;
        }
        catch (java.io.IOException e) {
            return null;
        }
    }
}

