/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.common;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.common.ClientInstance;
import com.jcloud.jcq.client.common.QueueSelector;
import com.jcloud.jcq.client.common.RemotingApiWrapper;
import com.jcloud.jcq.client.common.RequestHandler;
import com.jcloud.jcq.client.trace.TraceDispatcher;
import com.jcloud.jcq.common.queue.QueueRouteInfo;
import com.jcloud.jcq.common.service.ServiceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements ClientInstance {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected volatile ServiceState state = ServiceState.CREATE;
    protected final RemotingApiWrapper remotingApiWrapper = RemotingApiWrapper.getInstance();
    protected final QueueSelector queueSelector;
    protected final RequestHandler requestHandler = RequestHandler.getInstance();
    protected TraceDispatcher traceDispatcher;
    protected String accessKey;
    protected String secretKey;

    public AbstractClient() {
        this.queueSelector = new QueueSelector(this);
    }

    @Override
    public void start() throws ClientException {
        switch (this.state) {
            case CREATE: {
                this.doStart();
                break;
            }
            case RUNNING: {
                this.logger.info("instance {} is already running.", (Object)this.getInstanceId());
                break;
            }
            case SHUTDOWN: {
                String msg = String.format("instance [%s] is already shutdown, cannot be started.", this.getInstanceId());
                this.logger.warn(msg);
                throw new ClientException(msg, ClientExceptionCode.OPERATION_NOT_SUPPORTED_BY_CURRENT_CLIENT_STATE.getCode());
            }
        }
    }

    @Override
    public void shutdown() throws ClientException {
        switch (this.state) {
            case CREATE: {
                this.state = ServiceState.SHUTDOWN;
                break;
            }
            case RUNNING: {
                this.doShutdown();
                break;
            }
            case SHUTDOWN: {
                this.logger.info("instance {} is already shutdown.", (Object)this.getInstanceId());
                break;
            }
        }
    }

    private void doStart() throws ClientException {
        this.checkClientConfig();
        if (this.isMessageTraceOn()) {
            this.traceDispatcher.start();
        }
        this.requestHandler.registerClientInstance(this);
        this.doBeforeStart();
        this.queueSelector.start();
        this.state = ServiceState.RUNNING;
        this.logger.info("instance {} is started successfully.", (Object)this.getInstanceId());
    }

    private void doShutdown() throws ClientException {
        this.queueSelector.shutdown();
        this.doBeforeShutdown();
        this.requestHandler.unregisterClientInstance(this);
        this.notifyInstanceDown2Server();
        if (this.isMessageTraceOn()) {
            this.traceDispatcher.shutdown();
        }
        this.state = ServiceState.SHUTDOWN;
        this.logger.info("instance {} is shutdown successfully.", (Object)this.getInstanceId());
    }

    protected abstract void doBeforeStart() throws ClientException;

    protected abstract void doBeforeShutdown() throws ClientException;

    protected void checkClientConfig() throws ClientException {
        this.getClientConfig().validate();
    }

    protected void notifyInstanceDown2Server() throws ClientException {
        for (String address : this.queueSelector.getBrokerGroupAddressMap().values()) {
            this.remotingApiWrapper.notifyInstanceDown2Server(this, address);
        }
    }

    protected QueueRouteInfo selectQueue(String topic) throws ClientException {
        return this.queueSelector.selectQueueByTopic(topic);
    }

    @Override
    public QueueSelector getQueueSelector() {
        return this.queueSelector;
    }

    @Override
    public TraceDispatcher getTraceDispatcher() {
        return this.traceDispatcher;
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }
}

