/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.common;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.common.ClientInstance;
import com.jcloud.jcq.client.common.ClientRebalanceStrategy;
import com.jcloud.jcq.client.common.QueueRebalanceListener;
import com.jcloud.jcq.client.common.QueueSelectStrategy;
import com.jcloud.jcq.client.common.RemotingApiWrapper;
import com.jcloud.jcq.client.common.impl.ClientRebalanceAverageStrategy;
import com.jcloud.jcq.client.common.impl.RoundRobinQueueSelectStrategy;
import com.jcloud.jcq.client.consumer.Consumer;
import com.jcloud.jcq.common.client.ClientInstanceType;
import com.jcloud.jcq.common.queue.Queue;
import com.jcloud.jcq.common.queue.QueueRouteInfo;
import com.jcloud.jcq.common.thread.ThreadFactoryImpl;
import com.jcloud.jcq.common.topic.TopicRouteInfoV2;
import com.jcloud.jcq.common.topic.TopicType;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.protocol.client.GetTopicRouteInfoRequestV2;
import com.jcloud.jcq.protocol.client.GetTopicRouteInfoResponseV2;
import com.jcloud.jcq.protocol.client.GetTraceTopicRouteInfoRequest;
import com.jcloud.jcq.protocol.client.GetTraceTopicRouteInfoResponse;
import com.jcloud.jcq.protocol.client.UnregisterClientRequest;
import com.jcloud.jcq.protocol.client.UnregisterClientResponse;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueSelector {
    private static final Logger logger = LoggerFactory.getLogger(QueueSelector.class);
    protected final RemotingApiWrapper remotingApiWrapper = RemotingApiWrapper.getInstance();
    private ConcurrentMap<String, List<QueueRouteInfo>> topicQueuesMap = new ConcurrentHashMap<String, List<QueueRouteInfo>>();
    private ConcurrentMap<String, List<String>> topicClientsMap = new ConcurrentHashMap<String, List<String>>();
    private ConcurrentMap<String, TopicType> topicTypeMap = new ConcurrentHashMap<String, TopicType>();
    private ConcurrentMap<String, String> brokerGroupAddressMap = new ConcurrentHashMap<String, String>();
    private ConcurrentMap<String, String> addressBrokerGroupMap = new ConcurrentHashMap<String, String>();
    private ConcurrentSet<String> topics = new ConcurrentSet();
    private ClientRebalanceStrategy clientRebalanceStrategy = new ClientRebalanceAverageStrategy();
    private QueueSelectStrategy queueSelectStrategy = new RoundRobinQueueSelectStrategy();
    private ClientInstance clientInstance;
    private ScheduledExecutorService scheduledExecutorService;
    private QueueRebalanceListener queueRebalanceListener;
    private String tenantId = "";
    private String traceTopic = "";
    private ConcurrentMap<Integer, QueueRouteInfo> traceQueueRoutes = new ConcurrentHashMap<Integer, QueueRouteInfo>();

    public QueueSelector(ClientInstance clientInstance) {
        this.clientInstance = clientInstance;
    }

    public void start() {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryImpl(this.getClass().getSimpleName() + "ScheduleThread_"));
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    if (QueueSelector.this.clientInstance.isTraceProducer()) {
                        QueueSelector.this.refreshTraceTopicRoute();
                    } else {
                        QueueSelector.this.refreshRoute(null);
                        if (QueueSelector.this.queueRebalanceListener != null) {
                            Map topicAssignedQueuesMap = QueueSelector.this.getTopicAssignedQueuesMap();
                            QueueSelector.this.queueRebalanceListener.queueRebalanced(topicAssignedQueuesMap);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn("client:{} got exception:{} when refresh route", (Object)QueueSelector.this.clientInstance.getInstanceId(), (Object)e);
                }
            }
        }, this.clientInstance.getClientConfig().getRefreshRouteInterval(), this.clientInstance.getClientConfig().getRefreshRouteInterval(), TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        this.unregisterClient();
    }

    public void registerQueueRebalanceListener(QueueRebalanceListener queueRebalanceListener) {
        this.queueRebalanceListener = queueRebalanceListener;
    }

    public QueueRouteInfo selectQueueByTopic(String topic) throws ClientException {
        if (this.topicQueuesMap.get(topic) == null || ((List)this.topicQueuesMap.get(topic)).isEmpty()) {
            this.refreshRoute(topic);
        }
        if (this.topicQueuesMap.get(topic) == null || ((List)this.topicQueuesMap.get(topic)).isEmpty()) {
            logger.warn("no queue for topic:{}", (Object)topic);
            throw new ClientException(String.format("no queue for topic [%s]", topic), ClientExceptionCode.NOT_FOUND_QUEUE.getCode());
        }
        List queues = (List)this.topicQueuesMap.get(topic);
        List clients = (List)this.topicClientsMap.get(topic);
        List<QueueRouteInfo> queueRouteInfos = this.clientRebalanceStrategy.selectQueues(queues, this.clientInstance.getInstanceId(), clients, null);
        if (queueRouteInfos == null || queueRouteInfos.isEmpty()) {
            logger.warn("no queue assigned for client:{} topic:{} after rebalance, queues:{}, clients:{}", new Object[]{this.clientInstance.getInstanceId(), topic, queues, clients});
            return null;
        }
        return this.queueSelectStrategy.selectQueue(topic, queueRouteInfos);
    }

    public QueueRouteInfo getQueue(String topic, int queueId) throws ClientException {
        if (topic.equals(this.traceTopic)) {
            if (queueId >= this.traceQueueRoutes.size()) {
                return null;
            }
            return (QueueRouteInfo)this.traceQueueRoutes.get(queueId);
        }
        if (this.topicQueuesMap.get(topic) == null || ((List)this.topicQueuesMap.get(topic)).isEmpty()) {
            this.refreshRoute(topic);
        }
        if (this.topicQueuesMap.get(topic) == null || ((List)this.topicQueuesMap.get(topic)).isEmpty()) {
            logger.warn("no queue for topic:{}", (Object)topic);
            throw new ClientException(String.format("no queue for topic [%s]", topic), ClientExceptionCode.NOT_FOUND_QUEUE.getCode());
        }
        for (QueueRouteInfo queueRouteInfo : (List)this.topicQueuesMap.get(topic)) {
            if (queueRouteInfo.getQueueId() != queueId) continue;
            return queueRouteInfo;
        }
        return null;
    }

    public List<QueueRouteInfo> getQueuesByTopic(String topic) throws ClientException {
        if (this.topicQueuesMap.get(topic) == null || ((List)this.topicQueuesMap.get(topic)).isEmpty()) {
            this.refreshRoute(topic);
        }
        if (this.topicQueuesMap.get(topic) == null || ((List)this.topicQueuesMap.get(topic)).isEmpty()) {
            logger.warn("no queue for topic:{}", (Object)topic);
            return null;
        }
        return this.clientRebalanceStrategy.selectQueues((List)this.topicQueuesMap.get(topic), this.clientInstance.getInstanceId(), (List)this.topicClientsMap.get(topic), null);
    }

    public TopicType getTopicType(String topic) {
        if (StringUtils.isEmpty(topic)) {
            return null;
        }
        return (TopicType)((Object)this.topicTypeMap.get(topic));
    }

    public String getAlternativeAddress(String address) {
        if (this.clientInstance.isTraceProducer()) {
            return this.getTraceBrokerAlternativeAddress(address);
        }
        if (StringUtils.isEmpty(address)) {
            return null;
        }
        String brokerGroupId = (String)this.addressBrokerGroupMap.get(address);
        if (StringUtils.isEmpty(brokerGroupId)) {
            logger.warn("cannot find broker group with address:{}", (Object)address);
            return null;
        }
        String bgAddress = (String)this.brokerGroupAddressMap.get(brokerGroupId);
        if (!StringUtils.isEmpty(bgAddress) && !bgAddress.equals(address)) {
            return bgAddress;
        }
        try {
            this.refreshRoute(null);
        }
        catch (ClientException e) {
            logger.warn("client:{} got exception:{} when get route info for topic:{}", new Object[]{this.clientInstance.getInstanceId(), e, this.topicQueuesMap.keySet()});
        }
        return (String)this.brokerGroupAddressMap.get(brokerGroupId);
    }

    private String getTraceBrokerAlternativeAddress(String address) {
        if (StringUtils.isEmpty(address)) {
            return null;
        }
        String brokerGroupId = (String)this.addressBrokerGroupMap.get(address);
        if (StringUtils.isEmpty(brokerGroupId)) {
            logger.warn("cannot find broker group with address:{}", (Object)address);
            return null;
        }
        String bgAddress = (String)this.brokerGroupAddressMap.get(brokerGroupId);
        if (!StringUtils.isEmpty(bgAddress) && !bgAddress.equals(address)) {
            return bgAddress;
        }
        try {
            this.refreshTraceTopicRoute();
        }
        catch (ClientException e) {
            logger.warn("client: {} got exception: {} when refresh trace route for alternative trace broker address for: {}.", new Object[]{this.clientInstance.getInstanceId(), e, address});
        }
        return (String)this.brokerGroupAddressMap.get(brokerGroupId);
    }

    public ConcurrentMap<String, String> getBrokerGroupAddressMap() {
        return this.brokerGroupAddressMap;
    }

    public void removeTopic(String topic) {
        if (this.topics != null && !StringUtils.isEmpty(topic)) {
            this.topics.remove((Object)topic);
        }
    }

    private void refreshRoute(String topic) throws ClientException {
        if (!StringUtils.isEmpty(topic)) {
            this.topics.add((Object)topic);
        }
        if (this.topics.isEmpty()) {
            logger.info("topics is empty for client:{}", (Object)this.clientInstance.getInstanceId());
            this.topicQueuesMap.clear();
            this.topicClientsMap.clear();
            return;
        }
        GetTopicRouteInfoRequestV2 getTopicRouteInfoRequestV2 = new GetTopicRouteInfoRequestV2();
        getTopicRouteInfoRequestV2.setTopics(new ArrayList<String>((Collection<String>)this.topics));
        getTopicRouteInfoRequestV2.setClientId(this.clientInstance.getInstanceId());
        getTopicRouteInfoRequestV2.setClientInstanceType(this.clientInstance instanceof Consumer ? ClientInstanceType.CONSUMER : ClientInstanceType.PRODUCER);
        getTopicRouteInfoRequestV2.setConsumerGroupId(this.clientInstance instanceof Consumer ? ((Consumer)this.clientInstance).getConsumerGroupId() : null);
        GetTopicRouteInfoResponseV2 getTopicRouteInfoResponseV2 = this.remotingApiWrapper.sync(this.clientInstance, this.clientInstance.getClientConfig().getMetaServerAddress(), getTopicRouteInfoRequestV2, GetTopicRouteInfoResponseV2.class);
        List<TopicRouteInfoV2> topicRouteInfoV2s = getTopicRouteInfoResponseV2.getTopicRouteInfos();
        Map<String, List<String>> topicClientMap = getTopicRouteInfoResponseV2.getClientMaps();
        Map<String, TopicType> topicTypeMap = getTopicRouteInfoResponseV2.getTopicTypeMap();
        logger.info("client:{} got topic route info:{} client info:{} topic type:{} for topics:{}", new Object[]{this.clientInstance.getInstanceId(), topicRouteInfoV2s, topicClientMap, topicTypeMap, this.topics});
        if (topicRouteInfoV2s == null || topicRouteInfoV2s.isEmpty()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                logger.warn("client:{} update topic route from server got exception: {}", (Object)this.clientInstance.getInstanceId(), (Object)e);
            }
        }
        if (!getTopicRouteInfoResponseV2.success()) {
            if (getTopicRouteInfoResponseV2.getResponseCode() == 201 || getTopicRouteInfoResponseV2.getResponseCode() == 901 || getTopicRouteInfoResponseV2.getResponseCode() == 202) {
                this.registerQueueInfo(null);
                this.registerClientInfo(null);
            }
            throw new ClientException(String.format("got response [%s] when querying route information for topics [%s]", getTopicRouteInfoResponseV2, this.topics), ClientExceptionCode.NOT_FOUND_QUEUE.getCode());
        }
        this.registerTopicInfo(topicTypeMap);
        this.registerQueueInfo(topicRouteInfoV2s);
        this.registerClientInfo(topicClientMap);
    }

    private void refreshTraceTopicRoute() throws ClientException {
        GetTraceTopicRouteInfoRequest request = new GetTraceTopicRouteInfoRequest();
        request.setClientId(this.clientInstance.getInstanceId());
        request.setClientInstanceType(ClientInstanceType.PRODUCER);
        GetTraceTopicRouteInfoResponse response = this.remotingApiWrapper.sync(this.clientInstance, this.clientInstance.getClientConfig().getMetaServerAddress(), new GetTraceTopicRouteInfoRequest(), GetTraceTopicRouteInfoResponse.class);
        this.tenantId = response.getTenantId();
        List<TopicRouteInfoV2> topicRouteInfoV2s = response.getTopicRouteInfos();
        if (!response.success()) {
            logger.error("Got unexpected response {} when querying trace route information.", (Object)response);
            throw new ClientException(String.format("got response [%s] when querying trace route information.", response), ClientExceptionCode.NOT_FOUND_QUEUE.getCode());
        }
        if (topicRouteInfoV2s == null) {
            logger.error("Got unexpected response {} when querying trace route information.", (Object)response);
            throw new ClientException(String.format("got response [%s] when querying trace route information.", response), ClientExceptionCode.NOT_FOUND_QUEUE.getCode());
        }
        HashMap traceTopicQueuesMap = new HashMap();
        for (TopicRouteInfoV2 topicRouteInfoV2 : topicRouteInfoV2s) {
            if (topicRouteInfoV2 == null || topicRouteInfoV2.getBroker() == null || topicRouteInfoV2.getQueues() == null || topicRouteInfoV2.getQueues().isEmpty()) continue;
            this.brokerGroupAddressMap.put(topicRouteInfoV2.getBroker().getBrokerGroupId(), topicRouteInfoV2.getBroker().getExternalAddress());
            this.addressBrokerGroupMap.put(topicRouteInfoV2.getBroker().getExternalAddress(), topicRouteInfoV2.getBroker().getBrokerGroupId());
            for (Map.Entry entry : topicRouteInfoV2.getQueues().entrySet()) {
                String topic = (String)entry.getKey();
                if (this.traceTopic.isEmpty()) {
                    this.traceTopic = topic;
                }
                List queues = (List)entry.getValue();
                ArrayList<QueueRouteInfo> queueRouteInfos = (ArrayList<QueueRouteInfo>)traceTopicQueuesMap.get(topic);
                if (queueRouteInfos == null) {
                    queueRouteInfos = new ArrayList<QueueRouteInfo>();
                    traceTopicQueuesMap.put(topic, queueRouteInfos);
                }
                for (Queue queue : queues) {
                    QueueRouteInfo queueRouteInfo = new QueueRouteInfo();
                    queueRouteInfo.setTopic(topic);
                    queueRouteInfo.setBrokerGroup(topicRouteInfoV2.getBroker().getBrokerGroupId());
                    queueRouteInfo.setAddress(topicRouteInfoV2.getBroker().getExternalAddress());
                    queueRouteInfo.setQueueId(queue.getQueueId());
                    queueRouteInfos.add(queueRouteInfo);
                }
            }
        }
        for (List queueRouteInfos : traceTopicQueuesMap.values()) {
            Collections.sort(queueRouteInfos);
            for (QueueRouteInfo queueRouteInfo : queueRouteInfos) {
                this.traceQueueRoutes.put(queueRouteInfo.getQueueId(), queueRouteInfo);
            }
        }
    }

    public String getTraceTopic() {
        if (this.traceTopic.isEmpty()) {
            try {
                this.refreshTraceTopicRoute();
            }
            catch (ClientException e) {
                logger.warn("client: {} update topic route from server got exception: {}.", (Object)this.clientInstance.getInstanceId(), (Object)e);
            }
        }
        return this.traceTopic;
    }

    public String getTenantId() {
        if (StringUtils.isEmpty(this.tenantId)) {
            try {
                this.refreshTraceTopicRoute();
            }
            catch (ClientException e) {
                logger.warn("client: {} update topic route from server got exception: {}.", (Object)this.clientInstance.getInstanceId(), (Object)e);
            }
        }
        return this.tenantId;
    }

    public List<QueueRouteInfo> getTraceQueueRoutes() {
        if (this.traceQueueRoutes.isEmpty()) {
            try {
                this.refreshTraceTopicRoute();
            }
            catch (ClientException e) {
                logger.warn("client: {} update topic route from server got exception: {}", (Object)this.clientInstance.getInstanceId(), (Object)e);
            }
        }
        return new ArrayList<QueueRouteInfo>(this.traceQueueRoutes.values());
    }

    private void registerTopicInfo(Map<String, TopicType> topicTypeMap) {
        if (topicTypeMap == null || topicTypeMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, TopicType> entry : topicTypeMap.entrySet()) {
            this.topicTypeMap.put(entry.getKey(), entry.getValue());
        }
    }

    private void registerQueueInfo(List<TopicRouteInfoV2> topicRouteInfoV2s) {
        if (topicRouteInfoV2s == null || topicRouteInfoV2s.isEmpty()) {
            this.topicQueuesMap.clear();
            return;
        }
        HashMap tmpTopicQueuesMap = new HashMap();
        for (TopicRouteInfoV2 topicRouteInfoV2 : topicRouteInfoV2s) {
            if (topicRouteInfoV2 == null || topicRouteInfoV2.getBroker() == null || topicRouteInfoV2.getQueues() == null || topicRouteInfoV2.getQueues().isEmpty()) continue;
            this.brokerGroupAddressMap.put(topicRouteInfoV2.getBroker().getBrokerGroupId(), topicRouteInfoV2.getBroker().getExternalAddress());
            this.addressBrokerGroupMap.put(topicRouteInfoV2.getBroker().getExternalAddress(), topicRouteInfoV2.getBroker().getBrokerGroupId());
            for (Map.Entry<String, List<Queue>> entry : topicRouteInfoV2.getQueues().entrySet()) {
                String topic = entry.getKey();
                List<Queue> queues = entry.getValue();
                ArrayList<QueueRouteInfo> queueRouteInfos = (ArrayList<QueueRouteInfo>)tmpTopicQueuesMap.get(topic);
                if (queueRouteInfos == null) {
                    queueRouteInfos = new ArrayList<QueueRouteInfo>();
                    tmpTopicQueuesMap.put(topic, queueRouteInfos);
                }
                for (Queue queue : queues) {
                    QueueRouteInfo queueRouteInfo = new QueueRouteInfo();
                    queueRouteInfo.setTopic(topic);
                    queueRouteInfo.setBrokerGroup(topicRouteInfoV2.getBroker().getBrokerGroupId());
                    queueRouteInfo.setAddress(topicRouteInfoV2.getBroker().getExternalAddress());
                    queueRouteInfo.setQueueId(queue.getQueueId());
                    queueRouteInfos.add(queueRouteInfo);
                }
            }
        }
        for (List queueRouteInfos : tmpTopicQueuesMap.values()) {
            Collections.sort(queueRouteInfos);
        }
        this.replaceAll(tmpTopicQueuesMap, this.topicQueuesMap);
    }

    private void registerClientInfo(Map<String, List<String>> topicClientsMap) {
        if (topicClientsMap == null || topicClientsMap.isEmpty()) {
            this.topicClientsMap.clear();
            return;
        }
        for (List<String> clients : topicClientsMap.values()) {
            Collections.sort(clients);
        }
        this.replaceAll(topicClientsMap, this.topicClientsMap);
    }

    private Map<String, List<QueueRouteInfo>> getTopicAssignedQueuesMap() {
        HashMap<String, List<QueueRouteInfo>> topicAssignedQueuesMap = new HashMap<String, List<QueueRouteInfo>>();
        for (Map.Entry entry : this.topicQueuesMap.entrySet()) {
            String topic = (String)entry.getKey();
            List queueRouteInfos = (List)entry.getValue();
            List clients = (List)this.topicClientsMap.get(topic);
            List<QueueRouteInfo> queues = this.clientRebalanceStrategy.selectQueues(queueRouteInfos, this.clientInstance.getInstanceId(), clients, null);
            topicAssignedQueuesMap.put(topic, queues);
        }
        return topicAssignedQueuesMap;
    }

    private <T> void replaceAll(Map<String, List<T>> source, ConcurrentMap<String, List<T>> dest) {
        for (Map.Entry<String, List<T>> entry : source.entrySet()) {
            dest.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, List<Object>> entry : dest.entrySet()) {
            if (source.containsKey(entry.getKey())) continue;
            dest.remove(entry.getKey());
        }
    }

    private void unregisterClient() {
        try {
            UnregisterClientRequest unregisterClientRequest = new UnregisterClientRequest();
            unregisterClientRequest.setClientId(this.clientInstance.getInstanceId());
            unregisterClientRequest.setClientInstanceType(this.clientInstance instanceof Consumer ? ClientInstanceType.CONSUMER : ClientInstanceType.PRODUCER);
            unregisterClientRequest.setConsumerGroupId(this.clientInstance instanceof Consumer ? ((Consumer)this.clientInstance).getConsumerGroupId() : null);
            UnregisterClientResponse unregisterClientResponse = this.remotingApiWrapper.sync(this.clientInstance, this.clientInstance.getClientConfig().getMetaServerAddress(), unregisterClientRequest, UnregisterClientResponse.class);
            logger.info("unregister client,response is {}", (Object)unregisterClientResponse);
        }
        catch (ClientException e) {
            logger.warn("unregister client failed, clientId:{}, exception:{}", (Object)this.clientInstance.getInstanceId(), (Object)e);
        }
    }
}

