/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.common;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.common.AsyncRequestCallback;
import com.jcloud.jcq.client.common.ClientConfig;
import com.jcloud.jcq.client.common.ClientInstance;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.communication.core.ChannelWrapper;
import com.jcloud.jcq.communication.core.CommunicationClientConfig;
import com.jcloud.jcq.communication.core.DefaultCommunicationClient;
import com.jcloud.jcq.communication.core.ResponseFuture;
import com.jcloud.jcq.communication.exception.CommunicationException;
import com.jcloud.jcq.communication.exception.CommunicationTimeoutException;
import com.jcloud.jcq.communication.portal.CommunicationClient;
import com.jcloud.jcq.communication.portal.CommunicationRequestHandler;
import com.jcloud.jcq.communication.portal.InvokeCallback;
import com.jcloud.jcq.communication.protocol.CommunicationType;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import com.jcloud.jcq.protocol.ProtocolSerializer;
import com.jcloud.jcq.protocol.Request;
import com.jcloud.jcq.protocol.Response;
import com.jcloud.jcq.protocol.client.ConnectBrokerRequest;
import com.jcloud.jcq.protocol.client.ConnectBrokerResponse;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotingApiWrapper {
    private static final Logger logger = LoggerFactory.getLogger(RemotingApiWrapper.class);
    private final CommunicationClient communicationClient = new DefaultCommunicationClient(new CommunicationClientConfig());
    private static final RemotingApiWrapper instance = new RemotingApiWrapper();
    private ConcurrentMap<String, Set<String>> akConnectedBrokersMap = new ConcurrentHashMap<String, Set<String>>();

    private RemotingApiWrapper() {
        this.communicationClient.start();
    }

    public static RemotingApiWrapper getInstance() {
        return instance;
    }

    public <T extends Response> T sync(ClientInstance clientInstance, String destAddress, Request request, Class<T> responseClass) throws ClientException {
        return this.sync(clientInstance, destAddress, request, responseClass, clientInstance.getClientConfig().getSendTimeout());
    }

    public <T extends Response> T sync(ClientInstance clientInstance, String destAddress, Request request, Class<T> responseClass, long timeout) throws ClientException {
        ChannelWrapper channelWrapper;
        AddressWrapper addressWrapper = new AddressWrapper(destAddress);
        boolean isRequest2Manager = this.isRequest2Manager(request.getRequestCode());
        if (!isRequest2Manager) {
            this.checkChannel(addressWrapper, clientInstance, timeout);
        }
        T response = this.commonSyncWithRetry(clientInstance, request, addressWrapper, responseClass, timeout);
        if (isRequest2Manager && (channelWrapper = this.communicationClient.getChannelWrapperByAddress(addressWrapper.getAddress())) != null) {
            channelWrapper.shutdownHeartbeatService();
        }
        return response;
    }

    public <T extends Response> void async(ClientInstance clientInstance, String destAddress, Request request, AsyncRequestCallback asyncRequestCallback, Class<T> responseClass) throws ClientException {
        this.async(clientInstance, destAddress, request, asyncRequestCallback, responseClass, 1, clientInstance.getClientConfig().getSendTimeout());
    }

    public <T extends Response> void async(ClientInstance clientInstance, String destAddress, Request request, AsyncRequestCallback asyncRequestCallback, Class<T> responseClass, long timeout) throws ClientException {
        this.async(clientInstance, destAddress, request, asyncRequestCallback, responseClass, 1, timeout);
    }

    private <T extends Response> void async(final ClientInstance clientInstance, String destAddress, final Request request, final AsyncRequestCallback asyncRequestCallback, final Class<T> responseClass, int tryNum, final long timeout) throws ClientException {
        final AddressWrapper addressWrapper = new AddressWrapper(destAddress);
        this.checkChannel(addressWrapper, clientInstance, timeout);
        Exception exception = null;
        CommunicationUnit communicationUnit = this.buildRequestCommunicationUnit(request, CommunicationType.ASYNC_REQUEST, clientInstance);
        String warnMessage = "";
        final int maxTryTimes = clientInstance.getClientConfig().getMaxRetryTimes() + 1;
        for (int i = tryNum; i <= maxTryTimes; ++i) {
            try {
                final int currentTryNum = i;
                logger.debug("async send request: {}, destAddress: {}", (Object)request, (Object)addressWrapper.getAddress());
                this.communicationClient.invokeAsync(addressWrapper.getAddress(), communicationUnit, new InvokeCallback(){

                    @Override
                    public void operationComplete(ResponseFuture responseFuture) {
                        try {
                            boolean lastTryFlag = currentTryNum == maxTryTimes;
                            CommunicationUnit responseCommunicationUnit = responseFuture.getResponseUnitImmediately();
                            if (responseCommunicationUnit == null || responseCommunicationUnit.getData() == null || responseCommunicationUnit.getData().length == 0) {
                                logger.warn("got empty response from address: {} for request: {}", (Object)addressWrapper.getAddress(), (Object)request);
                                if (!lastTryFlag) {
                                    RemotingApiWrapper.this.async(clientInstance, addressWrapper.getAddress(), request, asyncRequestCallback, responseClass, currentTryNum + 1, timeout);
                                } else if (asyncRequestCallback != null) {
                                    asyncRequestCallback.onException(new ClientException(String.format("no response from address %s", addressWrapper.getAddress())));
                                }
                                return;
                            }
                            Response response = (Response)ProtocolSerializer.decode(responseCommunicationUnit.getData(), responseClass);
                            if (response.success()) {
                                logger.debug("got response: {} from address: {}", (Object)response, (Object)addressWrapper.getAddress());
                                if (asyncRequestCallback != null) {
                                    asyncRequestCallback.onResponse(response);
                                }
                                return;
                            }
                            logger.warn("got response: {} from address: {} for request: {}", new Object[]{response, addressWrapper.getAddress(), request});
                            boolean suggestSwitchBrokerFlag = RemotingApiWrapper.this.suggestSwitchBrokerInResponse(response);
                            if (suggestSwitchBrokerFlag || RemotingApiWrapper.this.shouldRefreshRouteAfterLastTry(request, response, lastTryFlag)) {
                                String alternativeAddress = RemotingApiWrapper.this.getAlternativeAddress(clientInstance, addressWrapper.getAddress());
                                if (alternativeAddress == null || alternativeAddress.equals(addressWrapper.getAddress())) {
                                    if (suggestSwitchBrokerFlag) {
                                        RemotingApiWrapper.this.closeChannel(addressWrapper);
                                    }
                                    if (asyncRequestCallback != null) {
                                        asyncRequestCallback.onResponse(response);
                                    }
                                    return;
                                }
                                RemotingApiWrapper.this.closeChannel(addressWrapper);
                                RemotingApiWrapper.this.async(clientInstance, alternativeAddress, request, asyncRequestCallback, responseClass, 1, timeout);
                                logger.info("re-invoked async function with destination address:{} to replace address:{} for request:{}[{}]", new Object[]{alternativeAddress, addressWrapper.getAddress(), request.getRequestId(), request.getRequestCode()});
                                return;
                            }
                            if (!lastTryFlag && RemotingApiWrapper.this.suggestReconnectServerInResponse(response)) {
                                RemotingApiWrapper.this.connectBroker(addressWrapper, clientInstance, timeout);
                                RemotingApiWrapper.this.async(clientInstance, addressWrapper.getAddress(), request, asyncRequestCallback, responseClass, currentTryNum + 1, timeout);
                                return;
                            }
                            if (!lastTryFlag && RemotingApiWrapper.this.suggestRetryInResponse(response)) {
                                if (RemotingApiWrapper.this.shouldSlowDownRequestRate(response)) {
                                    Thread.sleep(100L);
                                }
                                RemotingApiWrapper.this.async(clientInstance, addressWrapper.getAddress(), request, asyncRequestCallback, responseClass, currentTryNum + 1, timeout);
                                return;
                            }
                            if (asyncRequestCallback != null) {
                                asyncRequestCallback.onResponse(response);
                            }
                            return;
                        }
                        catch (Exception e) {
                            logger.warn("get exception when get response from responseFuture, request: {}[{}], exception: {}", new Object[]{request.getRequestId(), request.getRequestCode(), e});
                            if (asyncRequestCallback != null) {
                                asyncRequestCallback.onException(e);
                            }
                            return;
                        }
                    }
                }, timeout);
                return;
            }
            catch (Exception e) {
                String alternativeAddress;
                exception = e;
                warnMessage = String.format("get exception when async request to address:[%s], request:[%s], exception:[%s]", addressWrapper.getAddress(), request, e);
                logger.warn("get exception when async request to address:{}, request:{}, try number:{}", new Object[]{addressWrapper.getAddress(), request, i});
                logger.warn("exception:", (Throwable)e);
                if (!(e instanceof CommunicationException) || (alternativeAddress = this.getAlternativeAddress(clientInstance, addressWrapper.getAddress())) == null || alternativeAddress.equals(addressWrapper.getAddress())) continue;
                addressWrapper.setAddress(alternativeAddress);
                this.checkChannel(addressWrapper, clientInstance, timeout);
                i = 0;
                continue;
            }
        }
        if (exception != null && exception instanceof CommunicationException) {
            throw new ClientException(warnMessage, exception instanceof CommunicationTimeoutException ? ClientExceptionCode.COMMUNICATION_TIMEOUT.getCode() : ClientExceptionCode.COMMUNICATION_OTHER.getCode());
        }
        throw new ClientException(warnMessage);
    }

    public void oneway(ClientInstance clientInstance, String destAddress, Request request) throws ClientException {
        AddressWrapper addressWrapper = new AddressWrapper(destAddress);
        this.checkChannel(addressWrapper, clientInstance, clientInstance.getClientConfig().getSendTimeout());
        CommunicationUnit communicationUnit = this.buildRequestCommunicationUnit(request, CommunicationType.ONE_WAY_REQUEST, clientInstance);
        String warnMessage = "";
        Exception exception = null;
        int maxTryTimes = 2;
        for (int i = 1; i <= maxTryTimes; ++i) {
            try {
                if (i == maxTryTimes) {
                    String alternativeAddress;
                    if (!(exception instanceof CommunicationException) || (alternativeAddress = this.getAlternativeAddress(clientInstance, addressWrapper.getAddress())) == null || alternativeAddress.equals(addressWrapper.getAddress())) break;
                    addressWrapper.setAddress(alternativeAddress);
                    this.checkChannel(addressWrapper, clientInstance, clientInstance.getClientConfig().getSendTimeout());
                }
                logger.debug("oneway send request:{}, destAddress:{}", (Object)request, (Object)addressWrapper.getAddress());
                this.communicationClient.invokeOneway(addressWrapper.getAddress(), communicationUnit);
                return;
            }
            catch (Exception e) {
                exception = e;
                warnMessage = String.format("get exception when oneway request to address:[%s], request:[%s], exception:[%s]", addressWrapper.getAddress(), request, e);
                logger.warn("get exception when oneway request to address:{}, request:{}, try number:{}", new Object[]{addressWrapper.getAddress(), request, i});
                logger.warn("exception:", (Throwable)e);
                continue;
            }
        }
        if (exception != null && exception instanceof CommunicationException) {
            throw new ClientException(warnMessage, exception instanceof CommunicationTimeoutException ? ClientExceptionCode.COMMUNICATION_TIMEOUT.getCode() : ClientExceptionCode.COMMUNICATION_OTHER.getCode());
        }
        throw new ClientException(warnMessage);
    }

    private CommunicationUnit buildRequestCommunicationUnit(Request request, CommunicationType communicationType, ClientInstance clientInstance) throws ClientException {
        request.setVersion(ClientConfig.CLIENT_VERSION.getVersion());
        request.setAccessKey(clientInstance.getAccessKey());
        if (!StringUtils.isEmpty(clientInstance.getClientConfig().getToken())) {
            request.setJcloudToken(DatatypeConverter.printBase64Binary((byte[])clientInstance.getClientConfig().getToken().getBytes(Charset.forName("UTF-8"))));
        }
        if (request.needAuth()) {
            try {
                request.sign(clientInstance.getSecretKey());
            }
            catch (Exception e) {
                logger.warn("got exception:{} when sign request:{}", (Object)e, (Object)request);
                throw new ClientException("got exception when sign request", e);
            }
        }
        CommunicationUnit communicationUnit = CommunicationUnit.createRequestCommunicationUnit(request.getRequestCode(), clientInstance.getClientConfig().getClientType(), communicationType);
        communicationUnit.setData(ProtocolSerializer.encode(request));
        return communicationUnit;
    }

    private void checkChannel(AddressWrapper addressWrapper, ClientInstance clientInstance, long timeout) throws ClientException {
        if (this.communicationClient.isRemoteAddressConnected(addressWrapper.getAddress()) && this.akConnectedBrokersMap.get(clientInstance.getAccessKey()) != null && ((Set)this.akConnectedBrokersMap.get(clientInstance.getAccessKey())).contains(addressWrapper.getAddress())) {
            return;
        }
        this.connectBroker(addressWrapper, clientInstance, timeout);
    }

    private void connectBroker(AddressWrapper addressWrapper, ClientInstance clientInstance, long timeout) throws ClientException {
        ConnectBrokerRequest connectBrokerRequest = new ConnectBrokerRequest();
        ConnectBrokerResponse connectBrokerResponse = this.commonSyncWithRetry(clientInstance, connectBrokerRequest, addressWrapper, ConnectBrokerResponse.class, timeout);
        if (connectBrokerResponse.success()) {
            logger.info("connect broker {} succeed.", (Object)addressWrapper.getAddress());
            HashSet<String> connectedBrokers = (HashSet<String>)this.akConnectedBrokersMap.get(clientInstance.getAccessKey());
            if (connectedBrokers == null) {
                connectedBrokers = new HashSet<String>();
                this.akConnectedBrokersMap.put(clientInstance.getAccessKey(), connectedBrokers);
            }
            connectedBrokers.add(addressWrapper.getAddress());
            return;
        }
        String warnMessage = String.format("fail to build connection to address[%s], response code[%d], response remark[%s]", addressWrapper.getAddress(), connectBrokerResponse.getResponseCode(), connectBrokerResponse.getRemark());
        logger.warn(warnMessage);
        throw new ClientException(warnMessage);
    }

    public void notifyInstanceDown2Server(ClientInstance clientInstance, String destAddress) throws ClientException {
    }

    private <T extends Response> T commonSyncWithRetry(ClientInstance clientInstance, Request request, AddressWrapper addressWrapper, Class<T> responseClass, long timeout) throws ClientException {
        CommunicationUnit requestCommunicationUnit = this.buildRequestCommunicationUnit(request, CommunicationType.SYNC_REQUEST, clientInstance);
        String warnMessage = "";
        int maxTryTimes = clientInstance.getClientConfig().getMaxRetryTimes() + 1;
        Exception exception = null;
        for (int i = 1; i <= maxTryTimes; ++i) {
            CommunicationUnit responseCommunicationUnit = null;
            try {
                boolean lastTryFlag;
                logger.debug("sync send request:{}, destAddress:{}", (Object)request, (Object)addressWrapper.getAddress());
                responseCommunicationUnit = this.communicationClient.invokeSync(addressWrapper.getAddress(), requestCommunicationUnit, timeout);
                if (responseCommunicationUnit == null || responseCommunicationUnit.getData() == null || responseCommunicationUnit.getData().length == 0) {
                    warnMessage = String.format("got empty response from address:%s for request:%s", addressWrapper.getAddress(), request);
                    logger.warn(warnMessage);
                    continue;
                }
                Response response = (Response)ProtocolSerializer.decode(responseCommunicationUnit.getData(), responseClass);
                if (response.success()) {
                    logger.debug("got response:{} from address:{}", (Object)response, (Object)addressWrapper.getAddress());
                    return (T)response;
                }
                logger.warn("got response:{} from address:{} for request:{}", new Object[]{response, addressWrapper.getAddress(), request});
                boolean suggestSwitchBrokerFlag = this.suggestSwitchBrokerInResponse(response);
                boolean bl = lastTryFlag = i == maxTryTimes;
                if (suggestSwitchBrokerFlag || this.shouldRefreshRouteAfterLastTry(request, response, lastTryFlag)) {
                    String alternativeAddress = this.getAlternativeAddress(clientInstance, addressWrapper.getAddress());
                    if (alternativeAddress == null || alternativeAddress.equals(addressWrapper.getAddress())) {
                        if (suggestSwitchBrokerFlag) {
                            this.closeChannel(addressWrapper);
                        }
                        return (T)response;
                    }
                    this.closeChannel(addressWrapper);
                    addressWrapper.setAddress(alternativeAddress);
                    if (!this.isRequest2Manager(request.getRequestCode()) && request.getRequestCode() != 108) {
                        this.checkChannel(addressWrapper, clientInstance, timeout);
                    }
                    i = 0;
                    continue;
                }
                if (!lastTryFlag && this.suggestReconnectServerInResponse(response)) {
                    this.connectBroker(addressWrapper, clientInstance, timeout);
                    continue;
                }
                if (!lastTryFlag && this.suggestRetryInResponse(response)) {
                    if (this.shouldSlowDownRequestRate(response)) {
                        Thread.sleep(100L);
                    }
                    continue;
                }
                return (T)response;
            }
            catch (Exception e) {
                String alternativeAddress;
                exception = e;
                warnMessage = String.format("get exception when sync request to address:[%s], request:[%s], exception:[%s]", addressWrapper.getAddress(), request, e);
                logger.warn("get exception when sync request to address:{}, request:{}, try number:{}", new Object[]{addressWrapper.getAddress(), request, i});
                logger.warn("exception:", (Throwable)e);
                if (!(e instanceof CommunicationException) || this.isRequest2Manager(request.getRequestCode()) || (alternativeAddress = this.getAlternativeAddress(clientInstance, addressWrapper.getAddress())) == null || alternativeAddress.equals(addressWrapper.getAddress())) continue;
                addressWrapper.setAddress(alternativeAddress);
                if (!this.isRequest2Manager(request.getRequestCode()) && request.getRequestCode() != 108) {
                    this.checkChannel(addressWrapper, clientInstance, timeout);
                }
                i = 0;
            }
        }
        if (exception != null && exception instanceof CommunicationException) {
            throw new ClientException(warnMessage, exception instanceof CommunicationTimeoutException ? ClientExceptionCode.COMMUNICATION_TIMEOUT.getCode() : ClientExceptionCode.COMMUNICATION_OTHER.getCode());
        }
        throw new ClientException(warnMessage);
    }

    public void registerRequestCode2Processor(Map<Short, ExecutorService> requestCodeExecutorServiceMap, CommunicationRequestHandler processor) {
        if (requestCodeExecutorServiceMap == null || requestCodeExecutorServiceMap.isEmpty()) {
            return;
        }
        if (processor == null) {
            return;
        }
        for (Map.Entry<Short, ExecutorService> entry : requestCodeExecutorServiceMap.entrySet()) {
            this.communicationClient.registerHandler(entry.getKey(), processor, entry.getValue());
        }
    }

    public boolean isConnectionActive(String address) {
        if (StringUtils.isEmpty(address)) {
            return false;
        }
        return this.communicationClient.isRemoteAddressConnected(address);
    }

    private boolean isRequest2Manager(short requestCode) {
        switch (requestCode) {
            case 205: {
                return true;
            }
            case 206: {
                return true;
            }
            case 1101: {
                return true;
            }
            case 212: {
                return true;
            }
        }
        return false;
    }

    private boolean suggestSwitchBrokerInResponse(Response response) {
        return response.getResponseCode() == 703 || response.getResponseCode() == 100 || response.getResponseCode() == 203 || response.getResponseCode() == 506;
    }

    private boolean shouldRefreshRouteAfterLastTry(Request request, Response response, boolean lastTry) {
        if (this.isRequest2Manager(request.getRequestCode()) || !lastTry) {
            return false;
        }
        return response.getResponseCode() == 106 || response.getResponseCode() == 2;
    }

    private boolean suggestRetryInResponse(Response response) {
        return response.getResponseCode() == 106 || response.getResponseCode() == 2 || response.getResponseCode() == 102 || response.getResponseCode() == 5 || response.getResponseCode() == 111;
    }

    private boolean shouldSlowDownRequestRate(Response response) {
        return response.getResponseCode() == 102 || response.getResponseCode() == 5 || response.getResponseCode() == 111;
    }

    private boolean suggestReconnectServerInResponse(Response response) {
        return response.getResponseCode() == 402;
    }

    private String getAlternativeAddress(ClientInstance clientInstance, String address) {
        if (clientInstance == null || address == null) {
            return null;
        }
        String alternativeAddress = clientInstance.getQueueSelector().getAlternativeAddress(address);
        logger.info("got alternative address:{} for address:{}", (Object)alternativeAddress, (Object)address);
        if (alternativeAddress != null && !alternativeAddress.equals(address) && this.akConnectedBrokersMap.get(clientInstance.getAccessKey()) != null) {
            ((Set)this.akConnectedBrokersMap.get(clientInstance.getAccessKey())).remove(address);
            logger.info("address:{} is removed from akConnectedBrokersMap of ak:{}", (Object)address, (Object)clientInstance.getAccessKey());
        }
        return alternativeAddress;
    }

    private void closeChannel(AddressWrapper addressWrapper) {
        ChannelWrapper channelWrapper = this.communicationClient.getChannelWrapperByAddress(addressWrapper.getAddress());
        if (channelWrapper != null && channelWrapper.getChannel() != null) {
            channelWrapper.shutdownHeartbeatService();
            channelWrapper.getChannel().close();
            logger.info("channel to remote address:{} is closed", (Object)addressWrapper.getAddress());
        }
    }

    private static class AddressWrapper {
        String address;

        public AddressWrapper(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }
    }
}

