/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.common.impl;

import com.jcloud.jcq.client.common.ClientRebalanceStrategy;
import com.jcloud.jcq.common.queue.QueueRouteInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRebalanceAverageStrategy
implements ClientRebalanceStrategy {
    private static final Logger logger = LoggerFactory.getLogger(ClientRebalanceAverageStrategy.class);

    @Override
    public List<QueueRouteInfo> selectQueues(List<QueueRouteInfo> queueRouteInfos, String clientId, List<String> allClientIds, Object extendParam) {
        String errorMsg = this.checkParam(queueRouteInfos, clientId, allClientIds);
        if (errorMsg != null) {
            logger.info("selectQueues invalid param,clientId is {},msg is {}", (Object)clientId, (Object)errorMsg);
            return Collections.emptyList();
        }
        int clientIndex = allClientIds.indexOf(clientId);
        int queueModClient = queueRouteInfos.size() % allClientIds.size();
        int averageQueueForClient = queueRouteInfos.size() < allClientIds.size() ? 1 : queueRouteInfos.size() / allClientIds.size();
        int startIndexForClient = queueRouteInfos.size() > allClientIds.size() ? averageQueueForClient * clientIndex + Math.min(clientIndex, queueModClient) : averageQueueForClient * clientIndex;
        int queueNumForClient = queueRouteInfos.size() > allClientIds.size() && clientIndex < queueModClient && queueModClient > 0 ? averageQueueForClient + 1 : averageQueueForClient;
        ArrayList<QueueRouteInfo> result = new ArrayList<QueueRouteInfo>(queueNumForClient);
        for (int i = 0; i < queueNumForClient; ++i) {
            result.add(queueRouteInfos.get((startIndexForClient + i) % queueRouteInfos.size()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("queues:{} assigned for client:{}", result, (Object)clientId);
        }
        return result;
    }

    private String checkParam(List<QueueRouteInfo> queueRouteInfos, String clientId, List<String> allClientIds) {
        if (queueRouteInfos == null || queueRouteInfos.isEmpty()) {
            return "queueRouteInfo is empty";
        }
        if (allClientIds == null || allClientIds.isEmpty()) {
            return "client is empty";
        }
        if (!allClientIds.contains(clientId)) {
            return clientId + " is not in allClientIds";
        }
        return null;
    }
}

