/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.consumer;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.common.ClientConfig;
import com.jcloud.jcq.common.consumer.ConsumeFromWhere;
import com.jcloud.jcq.common.utils.StringUtils;

public class ConsumerConfig
extends ClientConfig {
    private String consumerGroupId = null;
    private ConsumeFromWhere defaultConsumePosition = ConsumeFromWhere.HEAD;
    private int recommendedBatchSizePerPush = 32;
    private int recommendedPushInterval;
    private int consumePoolCoreSize = 4;
    private int messageBufferSize = 1024;
    private int ackPoolCoreSize = 2;
    private int ackBufferSize = 1024;
    private int consumeMaxRetryTimes = 2;

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public ConsumeFromWhere getDefaultConsumePosition() {
        return this.defaultConsumePosition;
    }

    public void setDefaultConsumePosition(ConsumeFromWhere defaultConsumePosition) {
        this.defaultConsumePosition = defaultConsumePosition;
    }

    public int getRecommendedBatchSizePerPush() {
        return this.recommendedBatchSizePerPush;
    }

    public void setRecommendedBatchSizePerPush(int recommendedBatchSizePerPush) {
        this.recommendedBatchSizePerPush = recommendedBatchSizePerPush;
    }

    public int getRecommendedPushInterval() {
        return this.recommendedPushInterval;
    }

    public void setRecommendedPushInterval(int recommendedPushInterval) {
        this.recommendedPushInterval = recommendedPushInterval;
    }

    public int getConsumePoolCoreSize() {
        return this.consumePoolCoreSize;
    }

    public void setConsumePoolCoreSize(int consumePoolCoreSize) {
        this.consumePoolCoreSize = consumePoolCoreSize;
    }

    public int getMessageBufferSize() {
        return this.messageBufferSize;
    }

    public void setMessageBufferSize(int messageBufferSize) {
        this.messageBufferSize = messageBufferSize;
    }

    public int getAckPoolCoreSize() {
        return this.ackPoolCoreSize;
    }

    public void setAckPoolCoreSize(int ackPoolCoreSize) {
        this.ackPoolCoreSize = ackPoolCoreSize;
    }

    public int getAckBufferSize() {
        return this.ackBufferSize;
    }

    public void setAckBufferSize(int ackBufferSize) {
        this.ackBufferSize = ackBufferSize;
    }

    public int getConsumeMaxRetryTimes() {
        return this.consumeMaxRetryTimes;
    }

    public void setConsumeMaxRetryTimes(int consumeMaxRetryTimes) {
        this.consumeMaxRetryTimes = consumeMaxRetryTimes;
    }

    @Override
    public void validate() throws ClientException {
        super.validate();
        if (StringUtils.isEmpty(this.consumerGroupId)) {
            throw new ClientException("consumerGroupId is empty", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.defaultConsumePosition == null) {
            throw new ClientException("defaultConsumePosition is null", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.recommendedBatchSizePerPush <= 0 || this.recommendedBatchSizePerPush > 32) {
            throw new ClientException(String.format("recommendedBatchSizePerPush:%d is invalid", this.recommendedBatchSizePerPush), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.consumePoolCoreSize <= 0) {
            throw new ClientException(String.format("consumePoolCoreSize:%d is invalid", this.consumePoolCoreSize), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.messageBufferSize <= 0) {
            throw new ClientException(String.format("messageBufferSize:%d is invalid", this.messageBufferSize), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.ackPoolCoreSize <= 0) {
            throw new ClientException(String.format("ackPoolCoreSize:%d is invalid", this.ackPoolCoreSize), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.ackBufferSize <= 0) {
            throw new ClientException(String.format("ackBufferSize:%d is invalid", this.ackBufferSize), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.consumeMaxRetryTimes < 0) {
            throw new ClientException(String.format("consumeMaxRetryTimes:%d is invalid", this.consumeMaxRetryTimes), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
    }

    public String toString() {
        return "ConsumerConfig{, consumerGroupId='" + this.consumerGroupId + '\'' + ", defaultConsumePosition=" + (Object)((Object)this.defaultConsumePosition) + ", recommendedBatchSizePerPush=" + this.recommendedBatchSizePerPush + ", recommendedPushInterval=" + this.recommendedPushInterval + ", consumePoolCoreSize=" + this.consumePoolCoreSize + ", messageBufferSize=" + this.messageBufferSize + ", ackPoolCoreSize=" + this.ackPoolCoreSize + ", ackBufferSize=" + this.ackBufferSize + ", consumeMaxRetryTimes=" + this.consumeMaxRetryTimes + ", clientType=" + (Object)((Object)this.clientType) + ", metaServerAddress='" + this.metaServerAddress + '\'' + ", maxRetryTimes=" + this.maxRetryTimes + "} ";
    }
}

