/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.consumer.impl;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.consumer.AsyncAckCallback;
import com.jcloud.jcq.client.consumer.AsyncPullCallback;
import com.jcloud.jcq.client.consumer.ConsumerConfig;
import com.jcloud.jcq.client.consumer.PullConsumer;
import com.jcloud.jcq.client.consumer.impl.DefaultConsumerImpl;
import com.jcloud.jcq.common.filter.FilterExpression;
import com.jcloud.jcq.common.message.AckAction;
import com.jcloud.jcq.common.queue.QueueRouteInfo;
import com.jcloud.jcq.common.service.ServiceState;
import com.jcloud.jcq.common.trace.TracePoint;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.protocol.client.AckMessageRequest;
import com.jcloud.jcq.protocol.client.AckMessageResponse;
import com.jcloud.jcq.protocol.client.PullMessageRequest;
import com.jcloud.jcq.protocol.client.PullMessageResponse;
import java.util.List;

public class DefaultPullConsumerImpl
extends DefaultConsumerImpl
implements PullConsumer {
    public DefaultPullConsumerImpl(String accessKey, String secretKey, String consumerId, ConsumerConfig consumerConfig) {
        super(accessKey, secretKey, consumerId, consumerConfig);
    }

    @Override
    public PullMessageResponse pullMessage(String topic, FilterExpression filterExpression) throws ClientException {
        return this.commonPull(topic, filterExpression, true, null, 0, -1);
    }

    @Override
    public PullMessageResponse pullMessage(String topic, FilterExpression filterExpression, int count) throws ClientException {
        return this.commonPull(topic, filterExpression, true, null, count, -1);
    }

    @Override
    public PullMessageResponse pullMessageFromQueue(String topic, FilterExpression filterExpression, int queueId) throws ClientException {
        return this.commonPull(topic, filterExpression, true, null, 0, queueId);
    }

    @Override
    public void pullMessageAsync(String topic, FilterExpression filterExpression, AsyncPullCallback callback) throws ClientException {
        if (callback == null) {
            throw new ClientException("asyncPullCallback is null", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        this.commonPull(topic, filterExpression, false, callback, 0, -1);
    }

    @Override
    public AckMessageResponse ackMessage(String topic, long ackIndex, AckAction ackAction, int queueId) throws ClientException {
        return this.commonAck(topic, ackIndex, ackAction, null, true, queueId);
    }

    @Override
    public void ackMessageAsync(String topic, long ackIndex, AckAction ackAction, AsyncAckCallback callback, int queueId) throws ClientException {
        if (callback == null) {
            throw new ClientException("asyncAckCallback is null", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        this.commonAck(topic, ackIndex, ackAction, callback, false, queueId);
    }

    /*
     * Unable to fully structure code
     */
    private AckMessageResponse commonAck(String topic, final long ackIndex, final AckAction ackAction, final AsyncAckCallback callback, boolean isSync, int queueId) throws ClientException {
        if (this.state != ServiceState.RUNNING) {
            throw new ClientException(String.format("consumer:[%s] is not running, cannot ack message", new Object[]{this.consumerId}), ClientExceptionCode.OPERATION_NOT_SUPPORTED_BY_CURRENT_CLIENT_STATE.getCode());
        }
        if (StringUtils.isEmpty(topic)) {
            throw new ClientException("topic is empty", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (ackAction == null) {
            throw new ClientException("ackAction is null", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (ackIndex < 0L) {
            throw new ClientException(String.format("ackIndex:[%d] is invalid", new Object[]{ackIndex}), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (queueId < 0) {
            throw new ClientException(String.format("queueId:[%d] is invalid", new Object[]{queueId}), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        queueRouteInfo = this.queueSelector.getQueue(topic, queueId);
        if (queueRouteInfo == null || StringUtils.isEmpty(queueRouteInfo.getAddress())) {
            throw new ClientException(String.format("cannot find broker with queueId:[%d]", new Object[]{queueId}), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        brokerAddress = queueRouteInfo.getAddress();
        ackMessageRequest = new AckMessageRequest();
        ackMessageRequest.setTopic(topic);
        ackMessageRequest.setAckAction(ackAction);
        ackMessageRequest.setAckIndex(ackIndex);
        ackMessageRequest.setConsumerGroupId(this.consumerGroupId);
        ackMessageResponse = null;
        if (isSync) {
            try {
                ackMessageResponse = this.remotingApiWrapper.sync(this, brokerAddress, ackMessageRequest, AckMessageResponse.class);
                if (!this.isMessageTraceOn() || ackMessageResponse == null) ** GOTO lbl34
                this.completeAndAppendAfterConsumeTracePoints(ackMessageResponse, brokerAddress, ackIndex, ackAction == AckAction.SUCCESS && ackMessageResponse.success() != false);
            }
            catch (ClientException e) {
                if (this.isMessageTraceOn()) {
                    response = new AckMessageResponse();
                    response.setRequestId(ackMessageRequest.getRequestId());
                    this.completeAndAppendAfterConsumeTracePoints(response, brokerAddress, ackIndex, false);
                }
                throw e;
            }
        } else {
            this.remotingApiWrapper.async(this, brokerAddress, ackMessageRequest, new AsyncAckCallback(){
                String requestId;
                {
                    this.requestId = ackMessageRequest.getRequestId();
                }

                @Override
                public void onResponse(AckMessageResponse response) {
                    callback.onResponse(response);
                    if (DefaultPullConsumerImpl.this.isMessageTraceOn() && response != null) {
                        DefaultPullConsumerImpl.this.completeAndAppendAfterConsumeTracePoints(response, brokerAddress, ackIndex, ackAction == AckAction.SUCCESS && response.success());
                    }
                }

                @Override
                public void onException(Throwable throwable) {
                    callback.onException(throwable);
                    AckMessageResponse response = new AckMessageResponse();
                    response.setRequestId(this.requestId);
                    DefaultPullConsumerImpl.this.completeAndAppendAfterConsumeTracePoints(response, brokerAddress, ackIndex, false);
                }
            }, AckMessageResponse.class);
        }
lbl34:
        // 3 sources

        this.logger.info("ackIndex: {}, ackAction: {}, queueId: {} ackMessage to broker: {} done.", new Object[]{ackIndex, ackAction.name(), queueId, brokerAddress});
        return ackMessageResponse;
    }

    private PullMessageResponse commonPull(String topic, FilterExpression filterExpression, boolean isSync, final AsyncPullCallback callback, int count, int queueId) throws ClientException {
        if (this.state != ServiceState.RUNNING) {
            throw new ClientException(String.format("consumer:[%s] is not running, cannot pull message", this.consumerId), ClientExceptionCode.OPERATION_NOT_SUPPORTED_BY_CURRENT_CLIENT_STATE.getCode());
        }
        if (StringUtils.isEmpty(topic)) {
            throw new ClientException("topic is empty", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        this.checkFilterExpression(filterExpression);
        QueueRouteInfo queueRouteInfo = null;
        if (queueId >= 0) {
            queueRouteInfo = this.queueSelector.getQueue(topic, queueId);
            if (queueRouteInfo == null) {
                throw new ClientException(String.format("pull message failed, cannot find queue with queueId:%d for topic:%s", queueId, topic), ClientExceptionCode.NOT_FOUND_QUEUE.getCode());
            }
        } else {
            queueRouteInfo = this.selectQueue(topic);
            if (queueRouteInfo == null) {
                throw new ClientException(String.format("pull message failed, cannot find queue for topic:%s", topic), ClientExceptionCode.NOT_FOUND_QUEUE.getCode());
            }
        }
        PullMessageRequest pullMessageRequest = new PullMessageRequest();
        pullMessageRequest.setQueueId(queueRouteInfo.getQueueId());
        pullMessageRequest.setTopic(topic);
        pullMessageRequest.setConsumerGroupId(this.consumerGroupId);
        pullMessageRequest.setConsumerId(this.consumerId);
        pullMessageRequest.setConsumeFromWhere(this.consumerConfig.getDefaultConsumePosition());
        pullMessageRequest.setMaxPullNums(count <= 0 || count > this.consumerConfig.getRecommendedBatchSizePerPush() ? this.consumerConfig.getRecommendedBatchSizePerPush() : count);
        pullMessageRequest.setFilterExpression(filterExpression);
        PullMessageResponse pullMessageResponse = null;
        final String brokerAddress = queueRouteInfo.getAddress();
        if (isSync) {
            pullMessageResponse = this.remotingApiWrapper.sync(this, brokerAddress, pullMessageRequest, PullMessageResponse.class);
            if (this.isMessageTraceOn() && pullMessageResponse != null) {
                List<TracePoint> beforeConsumeTracePoints = this.getTracePoints(pullMessageResponse.getMessages());
                this.completeAndAppendBeforeConsumeTracePoints(beforeConsumeTracePoints, brokerAddress, pullMessageResponse, pullMessageResponse.getAckIndex());
            }
            this.tryDecompressMessages(pullMessageResponse.getMessages());
        } else {
            this.remotingApiWrapper.async(this, queueRouteInfo.getAddress(), pullMessageRequest, new AsyncPullCallback(){

                @Override
                public void onResponse(PullMessageResponse response) {
                    try {
                        DefaultPullConsumerImpl.this.tryDecompressMessages(response.getMessages());
                        callback.onResponse(response);
                        if (DefaultPullConsumerImpl.this.isMessageTraceOn()) {
                            List<TracePoint> beforeConsumeTracePoints = DefaultPullConsumerImpl.this.getTracePoints(response.getMessages());
                            DefaultPullConsumerImpl.this.completeAndAppendBeforeConsumeTracePoints(beforeConsumeTracePoints, brokerAddress, response, response.getAckIndex());
                        }
                    }
                    catch (ClientException e) {
                        callback.onException(e);
                    }
                }

                @Override
                public void onException(Throwable throwable) {
                    callback.onException(throwable);
                }
            }, PullMessageResponse.class);
        }
        this.logger.debug("{} pull message finished, {}", (Object)(isSync ? "sync" : "async"), (Object)pullMessageRequest);
        return pullMessageResponse;
    }
}

