/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.producer;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.common.ClientConfig;
import com.jcloud.jcq.common.message.MessageType;

public class ProducerConfig
extends ClientConfig {
    private int maxMsgSize = 262144;
    private int maxMsgNumsPerBatch = 32;
    private MessageType messageType = MessageType.NORMAL;
    private int compressMessageThreshold = 4096;
    private boolean enableCompress = true;

    public int getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public void setMaxMsgSize(int maxMsgSize) {
        this.maxMsgSize = maxMsgSize;
    }

    public int getMaxMsgNumsPerBatch() {
        return this.maxMsgNumsPerBatch;
    }

    public void setMaxMsgNumsPerBatch(int maxMsgNumsPerBatch) {
        this.maxMsgNumsPerBatch = maxMsgNumsPerBatch;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public int getCompressMessageThreshold() {
        return this.compressMessageThreshold;
    }

    public void setCompressMessageThreshold(int compressMessageThreshold) {
        this.compressMessageThreshold = compressMessageThreshold;
    }

    public boolean isEnableCompress() {
        return this.enableCompress;
    }

    public void setEnableCompress(boolean enableCompress) {
        this.enableCompress = enableCompress;
    }

    @Override
    public void validate() throws ClientException {
        super.validate();
        if (this.maxMsgSize <= 0) {
            throw new ClientException(String.format("maxMsgSize:%d is invalid", this.maxMsgSize), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.maxMsgNumsPerBatch <= 0) {
            throw new ClientException(String.format("maxMsgNumsPerBatch:%d is invalid", this.maxMsgNumsPerBatch), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.messageType == null) {
            throw new ClientException("messageType is null", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (this.compressMessageThreshold <= 0) {
            throw new ClientException(String.format("compressMessageThreshold:%d is invalid", this.compressMessageThreshold), ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
    }

    public String toString() {
        return "ProducerConfig{maxMsgSize=" + this.maxMsgSize + ", maxMsgNumsPerBatch=" + this.maxMsgNumsPerBatch + ", messageType=" + (Object)((Object)this.messageType) + ", clientType=" + (Object)((Object)this.clientType) + ", metaServerAddress='" + this.metaServerAddress + '\'' + ", maxRetryTimes=" + this.maxRetryTimes + ", compressMessageThreshold=" + this.compressMessageThreshold + ", enableCompress=" + this.enableCompress + "} ";
    }
}

