/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.client.producer;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.client.Exception.ClientExceptionCode;
import com.jcloud.jcq.client.producer.Producer;
import com.jcloud.jcq.client.producer.ProducerConfig;
import com.jcloud.jcq.client.producer.impl.DefaultProducerImpl;
import com.jcloud.jcq.common.utils.StringUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProducerFactory.class);
    private static final ProducerFactory instance = new ProducerFactory();
    private ConcurrentMap<String, Producer> producers = new ConcurrentHashMap<String, Producer>();

    private ProducerFactory() {
    }

    public static ProducerFactory getInstance() {
        return instance;
    }

    public Producer createProducer(String accessKey, String secretKey) throws ClientException {
        return this.createProducer(accessKey, secretKey, new ProducerConfig());
    }

    public synchronized Producer createProducer(String accessKey, String secretKey, ProducerConfig producerConfig) throws ClientException {
        this.validateParameters(accessKey, secretKey, producerConfig);
        String producerId = UUID.randomUUID().toString();
        DefaultProducerImpl producer = new DefaultProducerImpl(accessKey.trim(), secretKey.trim(), producerId, producerConfig);
        this.producers.put(producerId, producer);
        logger.debug("Producer {} is created with parameters:{}", (Object)producerId, (Object)producerConfig);
        return producer;
    }

    private void validateParameters(String accessKey, String secretKey, ProducerConfig producerConfig) throws ClientException {
        if (StringUtils.isEmpty(accessKey) || StringUtils.isEmpty(accessKey.trim())) {
            throw new ClientException("accessKey is empty.", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (StringUtils.isEmpty(secretKey) || StringUtils.isEmpty(secretKey.trim())) {
            throw new ClientException("secretKey is empty.", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        if (producerConfig == null) {
            throw new ClientException("producerConfig is null.", ClientExceptionCode.INVALID_PARAMETER.getCode());
        }
        producerConfig.validate();
    }
}

