/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.subscription;

import com.jcloud.jcq.common.Validator;
import com.jcloud.jcq.common.subscription.SubscriptionType;
import com.jcloud.jcq.common.utils.StringUtils;

public class Subscription
implements Validator {
    private String userId;
    private String topicName;
    private String consumerGroupId;
    private String endpoint;
    private int maxRetryTimes;
    private boolean DLQEnable = true;
    private SubscriptionType type = SubscriptionType.SDK;
    private int maxDLQNumbers = 10000;

    public Subscription() {
    }

    public Subscription(String userId, String consumerGroupId, String topicName) {
        this.userId = userId;
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
    }

    public Subscription(String userId, String topicName, String consumerGroupId, String endpoint) {
        this.userId = userId;
        this.topicName = topicName;
        this.consumerGroupId = consumerGroupId;
        this.endpoint = endpoint;
    }

    public String getId() {
        return StringUtils.join(this.userId, this.consumerGroupId);
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public boolean isDLQEnable() {
        return this.DLQEnable;
    }

    public void setDLQEnable(boolean DLQEnable) {
        this.DLQEnable = DLQEnable;
    }

    public SubscriptionType getType() {
        return this.type;
    }

    public void setType(SubscriptionType type) {
        this.type = type;
    }

    public int getMaxDLQNumbers() {
        return this.maxDLQNumbers;
    }

    public void setMaxDLQNumbers(int maxDLQNumbers) {
        this.maxDLQNumbers = maxDLQNumbers;
    }

    public String toString() {
        return "Subscription{userId='" + this.userId + '\'' + ",topicName='" + this.topicName + '\'' + ",consumerGroupId='" + this.consumerGroupId + '\'' + ",endpoint='" + this.endpoint + '\'' + ",maxRetryTimes'" + this.maxRetryTimes + '\'' + ",DLQEnable'" + this.DLQEnable + '\'' + ",type'" + (Object)((Object)this.type) + '\'' + '}';
    }

    @Override
    public boolean validate() {
        if (StringUtils.isEmpty(this.userId)) {
            return false;
        }
        if (StringUtils.isEmpty(this.consumerGroupId)) {
            return false;
        }
        return !StringUtils.isEmpty(this.topicName);
    }
}

