/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.thread;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)"ScheduledThreadPoolExecutor");

    public SafeScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(new SafeScheduledRunnable(command), initialDelay, period, unit);
    }

    class SafeScheduledRunnable
    implements Runnable {
        private Runnable runnable;

        SafeScheduledRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                logger.warn("Scheduled Runnable happened exception: {}, stack: {}", (Object)e, (Object)e.getStackTrace());
            }
        }
    }
}

