/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.trace;

import com.jcloud.jcq.common.trace.TracePoint;
import com.jcloud.jcq.common.trace.TraceType;
import com.jcloud.jcq.common.utils.StringUtils;

public class TraceStringHelper {
    public static String getTraceStringFromTracePoint(TracePoint tracePoint) {
        if (tracePoint == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (tracePoint.getTraceType()) {
            case PRODUCE: {
                stringBuilder.append(TraceType.PRODUCE.getCode()).append(",").append(tracePoint.getMessageId()).append(",").append(tracePoint.getBusinessId()).append(",").append(tracePoint.getClientAddress()).append(",").append(tracePoint.getRequestId()).append(",").append(tracePoint.getTopic()).append(",").append(tracePoint.getQueueId()).append(",").append(tracePoint.isSuccess()).append(",").append(tracePoint.getTimeStamp()).append(",").append(tracePoint.getCostTime()).append(",").append(tracePoint.getDelayTime()).append(",").append(tracePoint.getVersion().getCode());
                break;
            }
            case BEFORE_CONSUME: {
                stringBuilder.append(TraceType.BEFORE_CONSUME.getCode()).append(",").append(tracePoint.getMessageId()).append(",").append(tracePoint.getBusinessId()).append(",").append(tracePoint.getClientAddress()).append(",").append(tracePoint.getRequestId()).append(",").append(tracePoint.getTenantId()).append(",").append(tracePoint.getConsumerGroupId()).append(",").append(tracePoint.getRetryTimes()).append(",").append(tracePoint.getTimeStamp()).append(",").append(tracePoint.getVersion().getCode());
                break;
            }
            case AFTER_CONSUME: {
                stringBuilder.append(TraceType.AFTER_CONSUME.getCode()).append(",").append(tracePoint.getMessageId()).append(",").append(tracePoint.getBusinessId()).append(",").append(tracePoint.getClientAddress()).append(",").append(tracePoint.getRequestId()).append(",").append(tracePoint.isSuccess()).append(",").append(tracePoint.getTenantId()).append(",").append(tracePoint.getConsumerGroupId()).append(",").append(tracePoint.getRetryTimes()).append(",").append(tracePoint.getCostTime()).append(",").append(tracePoint.getVersion().getCode());
            }
        }
        return stringBuilder.toString();
    }

    public static TracePoint getTracePointFromTraceString(String traceString) {
        if (StringUtils.isEmpty(traceString)) {
            return null;
        }
        String[] segments = traceString.split(",", -1);
        if (segments.length < 1) {
            return null;
        }
        TracePoint tracePoint = new TracePoint();
        if (segments[0].equals(String.valueOf(TraceType.PRODUCE.getCode()))) {
            if (segments.length < 12) {
                return null;
            }
            tracePoint.setTraceType(TraceType.PRODUCE);
            tracePoint.setTopic(segments[5]);
            tracePoint.setQueueId(Integer.parseInt(segments[6]));
            tracePoint.setSuccess(Boolean.parseBoolean(segments[7]));
            tracePoint.setTimeStamp(Long.parseLong(segments[8]));
            tracePoint.setCostTime(Integer.parseInt(segments[9]));
            tracePoint.setDelayTime(Integer.parseInt(segments[10]));
        } else if (segments[0].equals(String.valueOf(TraceType.BEFORE_CONSUME.getCode()))) {
            if (segments.length < 10) {
                return null;
            }
            tracePoint.setTraceType(TraceType.BEFORE_CONSUME);
            tracePoint.setTenantId(segments[5]);
            tracePoint.setConsumerGroupId(segments[6]);
            tracePoint.setRetryTimes(Integer.parseInt(segments[7]));
            tracePoint.setTimeStamp(Long.parseLong(segments[8]));
        } else if (segments[0].equals(String.valueOf(TraceType.AFTER_CONSUME.getCode()))) {
            if (segments.length < 11) {
                return null;
            }
            tracePoint.setTraceType(TraceType.AFTER_CONSUME);
            tracePoint.setSuccess(Boolean.parseBoolean(segments[5]));
            tracePoint.setTenantId(segments[6]);
            tracePoint.setConsumerGroupId(segments[7]);
            tracePoint.setRetryTimes(Integer.parseInt(segments[8]));
            tracePoint.setCostTime(Integer.parseInt(segments[9]));
        } else {
            return null;
        }
        tracePoint.setMessageId(segments[1]);
        tracePoint.setBusinessId(segments[2]);
        tracePoint.setClientAddress(segments[3]);
        tracePoint.setRequestId(segments[4]);
        return tracePoint;
    }
}

