/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static Logger log = LoggerFactory.getLogger((String)FileUtils.class.getName());
    private static final String UTF8 = "UTF-8";

    private FileUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getTextFileContext(String filePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            boolean result;
            byte[] data = new byte[(int)file.length()];
            try (FileInputStream inputStream = new FileInputStream(file);){
                int len = inputStream.read(data);
                result = len == data.length;
            }
            if (result) {
                return new String(data, UTF8);
            }
        }
        return null;
    }

    public static void writeTextContextToFile(String fileName, String data) throws IOException {
        File file;
        String tmpFile = fileName + ".tmp";
        FileUtils.writeTextContextToFileNotSafe(tmpFile, data);
        String bakFile = fileName + ".bak";
        String prevContent = FileUtils.getTextFileContext(fileName);
        if (prevContent != null) {
            FileUtils.writeTextContextToFileNotSafe(bakFile, prevContent);
        }
        if ((file = new File(fileName)).delete()) {
            log.debug("delete file:{} success.", (Object)fileName);
        }
        if ((file = new File(tmpFile)).renameTo(new File(fileName))) {
            log.debug("rename:{} to {} success.", (Object)tmpFile, (Object)fileName);
        }
    }

    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static boolean isDirectoryEmpty(String directory) {
        File file = new File(directory);
        if (!file.exists()) {
            return true;
        }
        String[] files = file.list();
        return files == null || files.length == 0;
    }

    public static void mkdirs(String fileName) {
        if (new File(fileName).mkdirs()) {
            log.info("mkdirs success:{}", (Object)fileName);
        } else {
            log.warn("mkdirs failed:{}", (Object)fileName);
        }
    }

    public static String join(String file1, String file2) {
        if (StringUtils.isEmpty(file1) || StringUtils.isEmpty(file2)) {
            return !StringUtils.isEmpty(file1) ? file1 : file2;
        }
        StringBuilder sb = new StringBuilder(file1);
        if (file1.endsWith(File.separator) || file2.startsWith(File.separator)) {
            sb.append(file2);
        } else {
            sb.append(File.separator).append(file2);
        }
        return sb.toString();
    }

    public static String join(String ... paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        for (int index = 0; index < paths.length; ++index) {
            if (!StringUtils.isEmpty(paths[index])) continue;
            throw new IllegalArgumentException("null or empty error,param:" + Arrays.toString(paths));
        }
        StringBuilder sb = new StringBuilder(paths[0]);
        for (int i = 1; i < paths.length; ++i) {
            if (paths[i - 1].endsWith(File.separator) || paths[i].startsWith(File.separator)) {
                sb.append(paths[i]);
                continue;
            }
            sb.append(File.separator).append(paths[i]);
        }
        return sb.toString();
    }

    private static void writeTextContextToFileNotSafe(String fileName, String data) throws IOException {
        File file = new File(fileName);
        File fileParent = file.getParentFile();
        if (fileParent != null && fileParent.mkdirs()) {
            log.info("make directory:{} success.", (Object)fileName);
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);){
            outputStreamWriter.write(data);
        }
    }

    public static boolean makeDirIfNotExist(String path) {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            log.error("create dir {} failed, please check", (Object)path);
            return false;
        }
        return true;
    }

    public static String getParent(String path) {
        if (StringUtils.isEmpty(path)) {
            return path;
        }
        File file = new File(path);
        return file.getParent();
    }

    public static boolean delete(String path) {
        boolean result = true;
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File subFile : files) {
                result &= FileUtils.delete(subFile.getPath());
            }
        }
        return result && file.delete();
    }

    public static boolean deleteDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }

    public static boolean moveTo(File oldFile, File newFile) {
        if (oldFile == null || newFile == null) {
            return false;
        }
        try {
            Files.move(Paths.get(oldFile.getAbsolutePath(), new String[0]), Paths.get(newFile.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.error("move file {}, to {}, failed, exception is {}", new Object[]{oldFile.getAbsolutePath(), newFile.getAbsolutePath(), e});
            return false;
        }
        return true;
    }

    public static boolean touch(File file) {
        long currentTime;
        if (FileUtils.isDirectoryEmpty(file.getParent())) {
            FileUtils.mkdirs(file.getParent());
            log.info("health check directory created.");
        }
        if (!file.exists()) {
            try {
                new FileOutputStream(file).close();
                log.info("create file {} successfully when try to touch first time.", (Object)file);
            }
            catch (IOException e) {
                log.error("fail to create health file: {}, exception is {}", (Object)file.getAbsolutePath(), (Object)e);
                return false;
            }
        }
        if (file.setLastModified(currentTime = System.currentTimeMillis())) {
            log.info("touch health file: {} successfully at {}.", (Object)file, (Object)currentTime);
            return true;
        }
        log.info("touch health file: {} failed at {}.", (Object)file, (Object)currentTime);
        return false;
    }
}

