/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.common.utils;

import com.jcloud.jcq.common.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)ZipUtils.class.getName());
    private static final int BUFFER_SIZE = 1024;
    private static final String ZIP_SUFFIX = ".zip";

    public static void compress(String requestId, List<String> sourceFiles, String zipFile) throws IOException {
        if (sourceFiles == null || sourceFiles.isEmpty() || StringUtils.isEmpty(zipFile)) {
            return;
        }
        File zip = new File(zipFile.endsWith(ZIP_SUFFIX) ? zipFile : zipFile + ZIP_SUFFIX);
        if (!zip.exists()) {
            if (!zip.getParentFile().exists()) {
                zip.getParentFile().mkdir();
            }
            zip.createNewFile();
        }
        String pathPrefix = "";
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zip)));){
            for (String sourceFile : sourceFiles) {
                File file = new File(sourceFile);
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    ZipUtils.zipInFolder(requestId, file, zipOutputStream, pathPrefix);
                    continue;
                }
                ZipUtils.zipInFile(requestId, file, zipOutputStream, pathPrefix);
            }
        }
    }

    public static void decompress(String requestId, String zipFile, String destDir) throws IOException {
        if (StringUtils.isEmpty(zipFile) || StringUtils.isEmpty(destDir)) {
            return;
        }
        try (ZipFile zip = new ZipFile(zipFile);
             ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry;
            File outputDir = new File(destDir);
            if (!outputDir.exists()) {
                outputDir.mkdir();
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    ZipUtils.zipOutFolder(requestId, destDir, zipEntry);
                    continue;
                }
                ZipUtils.zipOutFile(requestId, destDir, zip, zipEntry);
            }
        }
    }

    private static void zipInFolder(String requestId, File file, ZipOutputStream zipOutputStream, String pathPrefix) throws IOException {
        if (file == null || !file.isDirectory() || zipOutputStream == null) {
            return;
        }
        String folderPath = pathPrefix == null ? file.getName() + "/" : pathPrefix + file.getName() + "/";
        zipOutputStream.putNextEntry(new ZipEntry(folderPath));
        zipOutputStream.closeEntry();
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                ZipUtils.zipInFolder(requestId, f, zipOutputStream, folderPath);
                continue;
            }
            ZipUtils.zipInFile(requestId, f, zipOutputStream, folderPath);
        }
    }

    private static void zipInFile(String requestId, File file, ZipOutputStream zipOutputStream, String pathPrefix) throws IOException {
        if (file == null || !file.isFile() || zipOutputStream == null) {
            return;
        }
        logger.info("requestId {} will compress file {}", (Object)requestId, (Object)file.getAbsolutePath());
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int length;
            ZipEntry zipEntry = new ZipEntry(pathPrefix == null ? file.getName() : pathPrefix + file.getName());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[1024];
            while ((length = fileInputStream.read(buffer, 0, 1024)) > 0) {
                zipOutputStream.write(buffer, 0, length);
            }
            zipOutputStream.closeEntry();
            zipEntry.setTime(file.lastModified());
        }
    }

    private static void zipOutFolder(String requestId, String pathPrefix, ZipEntry zipEntry) {
        if (zipEntry == null || !zipEntry.isDirectory()) {
            return;
        }
        File folder = new File(pathPrefix + "/" + zipEntry.getName());
        logger.info("requestId {} will deCompress folder {}", (Object)requestId, (Object)folder.getAbsolutePath());
        if (!folder.exists()) {
            folder.mkdir();
        }
    }

    private static void zipOutFile(String requestId, String pathPrefix, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        if (zipEntry == null || zipEntry.isDirectory()) {
            return;
        }
        File file = new File(pathPrefix + "/" + zipEntry.getName());
        logger.info("requestId {} will deCompress file {}", (Object)requestId, (Object)file.getAbsolutePath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            int length;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdir();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            byte[] buffer = new byte[1024];
            while ((length = bufferedInputStream.read(buffer, 0, 1024)) > 0) {
                fileOutputStream.write(buffer, 0, length);
            }
        }
        file.setLastModified(zipEntry.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] src) throws IOException {
        if (src == null || src.length == 0) {
            return src;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        Deflater deflater = new Deflater();
        deflater.reset();
        deflater.setInput(src);
        deflater.finish();
        byte[] block = new byte[1024];
        try {
            while (!deflater.finished()) {
                int len = deflater.deflate(block);
                byteArrayOutputStream.write(block, 0, len);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            deflater.end();
            byteArrayOutputStream.close();
        }
    }

    public static byte[] decompress(byte[] src) throws IOException {
        if (src == null || src.length == 0) {
            return src;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(src.length);
        Inflater inflater = new Inflater();
        inflater.reset();
        inflater.setInput(src);
        byte[] block = new byte[1024];
        try {
            while (!inflater.finished()) {
                int len = inflater.inflate(block);
                byteArrayOutputStream.write(block, 0, len);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (DataFormatException e) {
            throw new IOException(e);
        }
        finally {
            inflater.end();
            byteArrayOutputStream.close();
        }
    }
}

