/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.Pair;
import com.jcloud.jcq.common.client.ClientType;
import com.jcloud.jcq.common.utils.CommunicationUtils;
import com.jcloud.jcq.communication.common.SemaphoreReleaseOnlyOnce;
import com.jcloud.jcq.communication.core.ChannelEvent;
import com.jcloud.jcq.communication.core.ChannelWrapper;
import com.jcloud.jcq.communication.core.ResponseFuture;
import com.jcloud.jcq.communication.exception.CommunicationException;
import com.jcloud.jcq.communication.exception.CommunicationTimeoutException;
import com.jcloud.jcq.communication.portal.ChannelEventListener;
import com.jcloud.jcq.communication.portal.CommunicationRequestHandler;
import com.jcloud.jcq.communication.portal.InvokeCallback;
import com.jcloud.jcq.communication.portal.InvokeHook;
import com.jcloud.jcq.communication.protocol.CommunicationResponseType;
import com.jcloud.jcq.communication.protocol.CommunicationType;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommunicationAbstract {
    private final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");
    protected static final ConcurrentMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap<Integer, ResponseFuture>(512);
    protected final ConcurrentMap<Short, Pair<CommunicationRequestHandler, ExecutorService>> handlerTable = new ConcurrentHashMap<Short, Pair<CommunicationRequestHandler, ExecutorService>>(128);
    protected final Semaphore semaphoreOneWay;
    protected final Semaphore semaphoreAsync;
    protected final ChannelEventExecutor channelEventExecutor = new ChannelEventExecutor();
    protected Pair<CommunicationRequestHandler, ExecutorService> defaultCommunicationRequestHandler;

    public CommunicationAbstract(int maxConnectionOneway, int maxConnectionAsync) {
        this.semaphoreAsync = new Semaphore(maxConnectionAsync, true);
        this.semaphoreOneWay = new Semaphore(maxConnectionOneway, true);
    }

    protected void processReceivedMessage(ChannelWrapper cw, CommunicationUnit cu) {
        if (cu != null && this.validateCommunicationUnit(cw, cu)) {
            if (CommunicationType.isRequest(cu.getCommunicationType().getCode())) {
                this.handleRequestCommand(cw, cu);
            } else if (CommunicationType.isResponse(cu.getCommunicationType().getCode())) {
                this.handleResponseCommand(cw, cu);
            }
        }
    }

    protected void handleRequestCommand(ChannelWrapper cw, CommunicationUnit cu) {
        Pair<CommunicationRequestHandler, ExecutorService> matched = (Pair<CommunicationRequestHandler, ExecutorService>)this.handlerTable.get(cu.getCode());
        String channelWrapperString = cw.toStringBuilderWrapper().toString();
        if (matched == null) {
            matched = this.defaultCommunicationRequestHandler;
        }
        Pair<CommunicationRequestHandler, ExecutorService> pair = matched;
        int requestNumber = cu.getRequestNumber();
        if (pair != null && pair.getObject1() != null) {
            RequestCommandRun run = new RequestCommandRun(cw, cu, pair.getObject1(), requestNumber, this.getInvokeHook(), this.logger);
            if (pair.getObject1().rejectRequest()) {
                CommunicationUnit response = CommunicationUnit.createResponseCommunicationUnit(cu.getRequestNumber(), CommunicationResponseType.SYSTEM_BUSY.getCode(), CommunicationType.getResponseByRequest(cu.getCommunicationType()));
                response.setRequestNumber(requestNumber);
                response.setClientType(cu.getClientType());
                cw.getChannel().writeAndFlush((Object)response);
                return;
            }
            try {
                pair.getObject2().submit(run);
            }
            catch (RejectedExecutionException ree) {
                this.logger.warn("{}, Failed to submit the runnable task to the execution service, RejectedExecutionException {}, request code {}.", new Object[]{channelWrapperString, pair.getObject2().toString(), run.getCu().getCode()});
                if (CommunicationType.isRequest(cu.getCommunicationType().getCode()) && cu.getCommunicationType() != CommunicationType.ONE_WAY_REQUEST) {
                    CommunicationUnit response = CommunicationUnit.createResponseCommunicationUnit(cu.getRequestNumber(), CommunicationResponseType.SYSTEM_BUSY.getCode(), CommunicationType.getResponseByRequest(cu.getCommunicationType()));
                    response.setRequestNumber(requestNumber);
                    response.setClientType(cu.getClientType());
                    cw.getChannel().writeAndFlush((Object)response);
                }
            }
        } else {
            this.logger.error("{}, request type {} not supported.", (Object)channelWrapperString, (Object)cu.getCode());
            CommunicationUnit response = CommunicationUnit.createResponseCommunicationUnit(cu.getRequestNumber(), CommunicationResponseType.REQUEST_CODE_NOT_SUPPORTED.getCode(), CommunicationType.getResponseByRequest(cu.getCommunicationType()));
            response.setRequestNumber(requestNumber);
            response.setClientType(cu.getClientType());
            cw.getChannel().writeAndFlush((Object)response);
        }
    }

    protected void handleResponseCommand(ChannelWrapper cw, CommunicationUnit cu) {
        int requestNumber = cu.getRequestNumber();
        ResponseFuture rf = (ResponseFuture)responseTable.get(requestNumber);
        String channelString = CommunicationUtils.parseChannelAddress(cw.getChannel());
        if (rf == null) {
            String cuString = cu.toStringBuilderWrapper().toString();
            this.logger.warn("Received unmatched response from {}, {}", (Object)channelString, (Object)cuString);
            return;
        }
        rf.putResponseUnit(cu);
        rf.release();
        if (rf.getInvokeCallback() != null) {
            this.executeInvokeCallback(rf);
            responseTable.remove(requestNumber);
        }
    }

    public void putChannelEvent(ChannelEvent ce) {
        if (ce.getChannelWrapper().getChannelEventListener() != null) {
            this.getChannelEventExecutor().enqueueChannelEvent(ce, ce.getChannelWrapper().getChannelEventListener());
            return;
        }
        this.getChannelEventExecutor().enqueueChannelEvent(ce, this.getDefaultChannelEventListener());
    }

    private boolean validateCommunicationUnit(ChannelWrapper channelWrapper, CommunicationUnit communicationUnit) {
        boolean rs = true;
        if (communicationUnit == null) {
            this.logger.error("The request communication unit is null.");
            rs = false;
        } else {
            if (communicationUnit.getClientType() == null) {
                this.logger.error("The client type parameter of request communication unit is null, communication unit: {}", (Object)communicationUnit.toString());
                rs = false;
            } else if (communicationUnit.getCommunicationType() == null) {
                this.logger.error("The communication type parameter of request communication unit is null, communication unit: {}", (Object)communicationUnit.toString());
                rs = false;
            }
            if (!rs) {
                CommunicationUnit response = CommunicationUnit.createResponseCommunicationUnit(communicationUnit.getRequestNumber(), CommunicationResponseType.SYSTEM_ERROR.getCode(), communicationUnit.getCommunicationType() != null ? CommunicationType.getResponseByRequest(communicationUnit.getCommunicationType()) : CommunicationType.SYNC_RESPONSE);
                response.setRequestNumber(communicationUnit.getRequestNumber());
                response.setClientType(communicationUnit.getClientType() != null ? communicationUnit.getClientType() : ClientType.UNKNOWN);
                channelWrapper.getChannel().writeAndFlush((Object)response);
            }
        }
        return rs;
    }

    private void executeInvokeCallback(final ResponseFuture rf) {
        if (rf == null || rf.getInvokeCallback() == null) {
            return;
        }
        if (this.getCallbackExecutor() != null) {
            try {
                this.getCallbackExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        rf.getInvokeCallback().operationComplete(rf);
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn(e.getMessage());
                rf.getInvokeCallback().operationComplete(rf);
            }
            return;
        }
        rf.getInvokeCallback().operationComplete(rf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommunicationUnit invokeSyncImpl(Channel channel, CommunicationUnit request, long timeoutMillis) throws InterruptedException, CommunicationException {
        int requestNumber = request.getRequestNumber();
        try {
            final ResponseFuture rf = new ResponseFuture(requestNumber, timeoutMillis, null, null);
            responseTable.put(requestNumber, rf);
            channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture channelFuture) throws Exception {
                    if (channelFuture.isSuccess()) {
                        rf.setRequestSentSuccessfully(true);
                    } else {
                        rf.setRequestSentSuccessfully(false);
                        rf.setCause(channelFuture.cause());
                        rf.putResponseUnit(null);
                    }
                }
            });
            CommunicationUnit responseUnit = ((ResponseFuture)responseTable.get(requestNumber)).getResponseUnit();
            if (responseUnit == null) {
                if (rf.isRequestSentSuccessfully()) {
                    throw new CommunicationTimeoutException(CommunicationUtils.parseChannelAddress(channel), timeoutMillis, rf.getCause());
                }
                throw new CommunicationException(CommunicationUtils.parseChannelAddress(channel), rf.getCause());
            }
            CommunicationUnit communicationUnit = responseUnit;
            return communicationUnit;
        }
        finally {
            responseTable.remove(requestNumber);
        }
    }

    protected void invokeAsyncImpl(final Channel channel, CommunicationUnit request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, CommunicationException {
        final int requestNumber = request.getRequestNumber();
        boolean acquired = this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            final ResponseFuture rf = new ResponseFuture(requestNumber, timeoutMillis, invokeCallback, this.semaphoreAsync);
            responseTable.put(requestNumber, rf);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (channelFuture.isSuccess()) {
                            rf.setRequestSentSuccessfully(true);
                            return;
                        }
                        rf.setRequestSentSuccessfully(false);
                        rf.putResponseUnit(null);
                        if (responseTable.remove(requestNumber) != null) {
                            CommunicationAbstract.this.executeInvokeCallback(rf);
                        }
                        rf.release();
                        CommunicationAbstract.this.logger.warn("Send one async request to the channel <{}>, but failed.", (Object)CommunicationUtils.parseChannelAddress(channel));
                    }
                });
            }
            catch (Exception e) {
                rf.release();
                this.logger.warn("Send one async request to the remote channel <{}>, but got exception: {}.", (Object)CommunicationUtils.parseChannelAddress(channel), (Object)e.toString());
                throw new CommunicationException(String.format("Send one async request to the remote channel <%s>, but got exception: %s.", CommunicationUtils.parseChannelAddress(channel), e.toString()));
            }
        } else if (timeoutMillis <= 0L) {
            this.logger.warn("The timeoutMillis parameter {} for invokeAsyncImpl method is invalid.", (Object)timeoutMillis);
        } else {
            String info = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            this.logger.warn(info);
            throw new CommunicationTimeoutException(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeOneWayImpl(final Channel channel, CommunicationUnit request, long timeoutMillis) throws InterruptedException, CommunicationTimeoutException {
        request.setCommunicationType(CommunicationType.ONE_WAY_REQUEST);
        boolean acquired = this.semaphoreOneWay.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            final SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneWay);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (!channelFuture.isSuccess()) {
                            CommunicationAbstract.this.logger.warn("Send one one way request to the remote channel <{}>, but failed.", (Object)CommunicationUtils.parseChannelAddress(channel));
                        }
                        once.release();
                    }
                });
            }
            catch (Exception e) {
                this.logger.warn("Send one one way request to the remote channel <{}>, but got exception: {}.", (Object)CommunicationUtils.parseChannelAddress(channel), (Object)e.toString());
            }
            finally {
                once.release();
            }
        } else if (timeoutMillis <= 0L) {
            this.logger.warn("The timeoutMillis parameter {} for invokeOneWayImpl method is invalid.", (Object)timeoutMillis);
        } else {
            String info = String.format("invokeOneWayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreOneWayValue: %d", timeoutMillis, this.semaphoreOneWay.getQueueLength(), this.semaphoreOneWay.availablePermits());
            this.logger.warn(info);
            throw new CommunicationTimeoutException(info);
        }
    }

    public ChannelEventExecutor getChannelEventExecutor() {
        return this.channelEventExecutor;
    }

    public abstract InvokeHook getInvokeHook();

    public abstract ExecutorService getCallbackExecutor();

    public abstract ChannelEventListener getDefaultChannelEventListener();

    protected abstract ChannelWrapper getChannelWrapperByChannel(Channel var1);

    protected class DefaultCommunicationMessageHandler
    extends SimpleChannelInboundHandler<CommunicationUnit> {
        protected DefaultCommunicationMessageHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, CommunicationUnit cu) throws Exception {
            CommunicationAbstract.this.processReceivedMessage(CommunicationAbstract.this.getChannelWrapperByChannel(ctx.channel()), cu);
        }
    }

    protected static class DefaultThreadFactory
    implements ThreadFactory {
        private AtomicInteger threadIndex = new AtomicInteger(0);
        private AtomicInteger threadTotalNumber = new AtomicInteger(0);
        private String threadNamePrefix;

        public DefaultThreadFactory(int threadTotalNumber, String threadNamePrefix) {
            this.threadTotalNumber.set(threadTotalNumber);
            this.threadNamePrefix = threadNamePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, String.format("%s_%d_%d", this.threadNamePrefix, this.threadTotalNumber.get(), this.threadIndex.getAndIncrement()));
        }
    }

    protected class RequestCommandRun
    implements Runnable {
        private ChannelWrapper cw;
        private CommunicationUnit cu;
        private CommunicationRequestHandler handler;
        private int rn;
        private Logger logger;
        private InvokeHook invokeHook;

        public RequestCommandRun(ChannelWrapper cw, CommunicationUnit cu, CommunicationRequestHandler handler, int requestNumber, InvokeHook invokeHook, Logger logger) {
            this.setCw(cw);
            this.setCu(cu);
            this.setHandler(handler);
            this.setRn(requestNumber);
            this.setInvokeHook(invokeHook);
            this.setLogger(logger);
        }

        @Override
        public void run() {
            block5: {
                try {
                    if (this.getInvokeHook() != null) {
                        this.getInvokeHook().doBeforeRequest(CommunicationUtils.parseChannelRemoteAddr(this.getCw().getChannel()), this.getCu());
                    }
                    CommunicationUnit response = this.getHandler().processRequest(this.getCw(), this.getCu());
                    if (this.getInvokeHook() != null) {
                        this.getInvokeHook().doAfterResponse(CommunicationUtils.parseChannelRemoteAddr(this.getCw().getChannel()), this.getCu(), response);
                    }
                    if (response != null && response.getCommunicationType() != CommunicationType.ONE_WAY_RESPONSE) {
                        response.setRequestNumber(this.getRn());
                        response.setClientType(this.getCu().getClientType());
                        this.getCw().getChannel().writeAndFlush((Object)response);
                    }
                }
                catch (Exception e) {
                    this.getLogger().error("process request exception: {}", (Object[])e.getStackTrace());
                    this.getLogger().error(this.getCu().toString());
                    if (this.getCu() == null || this.getCu().getCommunicationType() == CommunicationType.ONE_WAY_REQUEST) break block5;
                    CommunicationUnit response = CommunicationUnit.createResponseCommunicationUnit(this.getCu().getRequestNumber(), CommunicationResponseType.SYSTEM_ERROR.getCode(), CommunicationType.getResponseByRequest(this.getCu().getCommunicationType()));
                    response.setRequestNumber(this.getRn());
                    response.setClientType(this.getCu().getClientType());
                    this.getCw().getChannel().writeAndFlush((Object)response);
                }
            }
        }

        public ChannelWrapper getCw() {
            return this.cw;
        }

        public void setCw(ChannelWrapper cw) {
            this.cw = cw;
        }

        public CommunicationUnit getCu() {
            return this.cu;
        }

        public void setCu(CommunicationUnit cu) {
            this.cu = cu;
        }

        public CommunicationRequestHandler getHandler() {
            return this.handler;
        }

        public void setHandler(CommunicationRequestHandler handler) {
            this.handler = handler;
        }

        public int getRn() {
            return this.rn;
        }

        public void setRn(int rn) {
            this.rn = rn;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public void setLogger(Logger logger) {
            this.logger = logger;
        }

        public InvokeHook getInvokeHook() {
            return this.invokeHook;
        }

        public void setInvokeHook(InvokeHook invokeHook) {
            this.invokeHook = invokeHook;
        }
    }

    protected class ChannelEventExecutor
    implements Runnable {
        private final LinkedBlockingDeque<Pair<ChannelEvent, ChannelEventListener>> queue = new LinkedBlockingDeque();
        private static final int MAX_QUEUE_LENGTH = 10000;
        private static final String SERVICE_NAME = "ChannelEventExecutor";
        private final Thread thread = new Thread((Runnable)this, this.getServiceName());
        private static final long POLL_MAX_INTERVAL = 5000L;
        private volatile boolean isRunning = false;

        protected ChannelEventExecutor() {
        }

        public void start() {
            this.isRunning = true;
            CommunicationAbstract.this.logger.info("Start running the ChannelEventExecutor");
            this.thread.start();
        }

        public void shutdown() {
            this.isRunning = false;
            CommunicationAbstract.this.logger.info("Terminate running the ChannelEventExecutor with {} events left.", (Object)this.getQueue().size());
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enqueueChannelEvent(ChannelEvent ce, ChannelEventListener cel) {
            boolean rs = false;
            ChannelEventExecutor channelEventExecutor = this;
            synchronized (channelEventExecutor) {
                if (this.getQueue().size() < this.getMaxQueueLength()) {
                    this.getQueue().add(new Pair<ChannelEvent, ChannelEventListener>(ce, cel));
                    rs = true;
                }
            }
            return rs;
        }

        @Override
        public void run() {
            block11: while (this.isRunning()) {
                try {
                    Pair<ChannelEvent, ChannelEventListener> pair = this.getQueue().take();
                    ChannelEvent ce = pair.getObject1();
                    ChannelEventListener cel = pair.getObject2();
                    switch (ce.getType()) {
                        case CONNECT: {
                            cel.onChannelConnect(ce.getRemoteAddress(), ce.getChannelWrapper());
                            continue block11;
                        }
                        case ALL_IDLE: {
                            cel.onChannelAllIdle(ce.getRemoteAddress(), ce.getChannelWrapper());
                            continue block11;
                        }
                        case READ_IDLE: {
                            cel.onChannelReadIdle(ce.getRemoteAddress(), ce.getChannelWrapper());
                            continue block11;
                        }
                        case WRITE_IDLE: {
                            cel.onChannelWriteIdle(ce.getRemoteAddress(), ce.getChannelWrapper());
                            continue block11;
                        }
                        case CLOSE: {
                            cel.onChannelClose(ce.getRemoteAddress(), ce.getChannelWrapper());
                            continue block11;
                        }
                        case EXCEPTION: {
                            cel.onChannelException(ce.getRemoteAddress(), ce.getChannelWrapper());
                            continue block11;
                        }
                    }
                    CommunicationAbstract.this.logger.warn("Unrecognized ChannelEventType {}", (Object)ce.getType());
                }
                catch (InterruptedException e) {
                    CommunicationAbstract.this.logger.info("thread may interrupt by shutdown function");
                }
                catch (Exception e) {
                    CommunicationAbstract.this.logger.error("{} is polling event from the queue, but got exception {}.", (Object)this.getServiceName(), (Object)e);
                }
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public LinkedBlockingDeque<Pair<ChannelEvent, ChannelEventListener>> getQueue() {
            return this.queue;
        }

        public int getMaxQueueLength() {
            return 10000;
        }

        public String getServiceName() {
            return SERVICE_NAME;
        }

        public long getPollMaxInterval() {
            return 5000L;
        }
    }

    protected class ScanResponseTableRunnable
    implements Runnable {
        protected ScanResponseTableRunnable() {
        }

        @Override
        public void run() {
            ArrayList<ResponseFuture> deprecatedResponseFuture = new ArrayList<ResponseFuture>();
            for (ResponseFuture rf : responseTable.values()) {
                if (rf.getCreationTimestamp() + rf.getTimeoutMillis() >= System.currentTimeMillis()) continue;
                deprecatedResponseFuture.add(rf);
                rf.release();
                responseTable.remove(rf.getRequestNumber());
                CommunicationAbstract.this.logger.warn("Remove deprecated ResponseFuture instance with request number <{}> from the response table.", (Object)rf.getRequestNumber());
            }
            for (ResponseFuture rf : deprecatedResponseFuture) {
                CommunicationAbstract.this.executeInvokeCallback(rf);
            }
        }
    }
}

