/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.core;

import com.jcloud.jcq.common.Pair;
import com.jcloud.jcq.common.utils.CommunicationUtils;
import com.jcloud.jcq.communication.core.ChannelEvent;
import com.jcloud.jcq.communication.core.ChannelEventType;
import com.jcloud.jcq.communication.core.ChannelWrapper;
import com.jcloud.jcq.communication.core.CommunicationAbstract;
import com.jcloud.jcq.communication.core.CommunicationClientConfig;
import com.jcloud.jcq.communication.core.DefaultChannelEventListener;
import com.jcloud.jcq.communication.core.DefaultDecoder;
import com.jcloud.jcq.communication.core.DefaultEncoder;
import com.jcloud.jcq.communication.exception.CommunicationException;
import com.jcloud.jcq.communication.exception.CommunicationTimeoutException;
import com.jcloud.jcq.communication.portal.ChannelEventListener;
import com.jcloud.jcq.communication.portal.CommunicationClient;
import com.jcloud.jcq.communication.portal.CommunicationRequestHandler;
import com.jcloud.jcq.communication.portal.InvokeCallback;
import com.jcloud.jcq.communication.portal.InvokeHook;
import com.jcloud.jcq.communication.protocol.CommunicationUnit;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommunicationClient
extends CommunicationAbstract
implements CommunicationClient {
    private final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");
    private CommunicationClientConfig communicationClientConfig;
    private EventLoopGroup eventLoopGroupWorker;
    private final Bootstrap bootstrap = new Bootstrap();
    private static final ConcurrentMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap<String, ChannelWrapper>();
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(3, new CommunicationAbstract.DefaultThreadFactory(10, "CommunicationClientScheduledTask"));
    private ExecutorService publicExecutor;
    private ChannelEventListener defaultChannelEventListener;
    private DefaultEventExecutorGroup defaultHandlerExecutorGroup;
    private InvokeHook invokeHook;
    private ChannelPipeline channelPipeline;
    private static ScheduledThreadPoolExecutor heartBeatScheduledThreadPoolExecutor;
    private static ScheduledThreadPoolExecutor cleanExecutor;
    private static AtomicInteger clientCountInSameJVM;
    private final Lock channelLock = new ReentrantLock();

    public DefaultCommunicationClient(CommunicationClientConfig communicationClientConfig) {
        this(communicationClientConfig, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultCommunicationClient(CommunicationClientConfig communicationClientConfig, ChannelEventListener channelEventListener) {
        super(communicationClientConfig.getClientOneWaySemaphoreValue(), communicationClientConfig.getClientAsyncSemaphoreValue());
        this.communicationClientConfig = communicationClientConfig;
        this.defaultChannelEventListener = channelEventListener == null ? new DefaultChannelEventListener() : channelEventListener;
        int publicThreadNums = communicationClientConfig.getClientCallbackExecutorThreads();
        int eventLoopWorkerThreadNums = communicationClientConfig.getClientEventLoopWorkerThreads();
        int workerThreadNums = communicationClientConfig.getClientWorkerThreads();
        int channelHeartBeatWorkerThreadNums = communicationClientConfig.getClientChannelHeartBeatWorkerThreads();
        int cleanWorkerThreadNums = communicationClientConfig.getClientChannelCleanWorkerThreads();
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new CommunicationAbstract.DefaultThreadFactory(publicThreadNums, "CommunicationClientPublicExecutor"));
        this.eventLoopGroupWorker = communicationClientConfig.isUseEpoll() && CommunicationUtils.isEpollAvailable() ? new EpollEventLoopGroup(eventLoopWorkerThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(eventLoopWorkerThreadNums, "CommunicationClientSelector")) : new NioEventLoopGroup(eventLoopWorkerThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(eventLoopWorkerThreadNums, "CommunicationClientSelector"));
        this.defaultHandlerExecutorGroup = new DefaultEventExecutorGroup(workerThreadNums, (ThreadFactory)new CommunicationAbstract.DefaultThreadFactory(workerThreadNums, "CommunicationClientWorkerThread"));
        Class<DefaultCommunicationClient> clazz = DefaultCommunicationClient.class;
        synchronized (DefaultCommunicationClient.class) {
            if (heartBeatScheduledThreadPoolExecutor == null && channelHeartBeatWorkerThreadNums > 0) {
                heartBeatScheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(channelHeartBeatWorkerThreadNums, new CommunicationAbstract.DefaultThreadFactory(channelHeartBeatWorkerThreadNums, "HeartBeatScheduledThreadPoolExecutor"));
            }
            if (cleanExecutor == null) {
                cleanExecutor = new ScheduledThreadPoolExecutor(cleanWorkerThreadNums, new CommunicationAbstract.DefaultThreadFactory(cleanWorkerThreadNums, "CommunicationClientChannelCleaner"));
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            clientCountInSameJVM.incrementAndGet();
            return;
        }
    }

    @Override
    public ChannelWrapper getChannelWrapperByAddress(String address) {
        return (ChannelWrapper)channelTables.get(address);
    }

    @Override
    public boolean isRemoteAddressConnected(String remoteAddress) {
        boolean rs = false;
        if (channelTables.get(remoteAddress) != null && ((ChannelWrapper)channelTables.get(remoteAddress)).isChannelActive()) {
            rs = true;
        }
        return rs;
    }

    @Override
    public InvokeHook getInvokeHook() {
        return this.invokeHook;
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    @Override
    public ChannelEventListener getDefaultChannelEventListener() {
        return this.defaultChannelEventListener;
    }

    @Override
    public void start() {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(this.communicationClientConfig.isUseEpoll() && CommunicationUtils.isEpollAvailable() ? EpollSocketChannel.class : NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.communicationClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, (Object)this.communicationClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.communicationClientConfig.getClientSocketRcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                DefaultCommunicationClient.this.channelPipeline = ch.pipeline();
                DefaultCommunicationClient.this.channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationClient.this.defaultHandlerExecutorGroup, "Encoder", (ChannelHandler)new DefaultEncoder());
                DefaultCommunicationClient.this.channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationClient.this.defaultHandlerExecutorGroup, "Decoder", (ChannelHandler)new DefaultDecoder());
                DefaultCommunicationClient.this.channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationClient.this.defaultHandlerExecutorGroup, "IdleStateHandler", (ChannelHandler)new IdleStateHandler(DefaultCommunicationClient.this.communicationClientConfig.getClientChannelReadIdleTimeSeconds(), DefaultCommunicationClient.this.communicationClientConfig.getClientChannelWriteIdleTimeSeconds(), DefaultCommunicationClient.this.communicationClientConfig.getClientChannelMaxIdleTimeSeconds()));
                DefaultCommunicationClient.this.channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationClient.this.defaultHandlerExecutorGroup, "ConnectManageHandler", (ChannelHandler)new DefaultClientConnectManageHandler());
                DefaultCommunicationClient.this.channelPipeline.addLast((EventExecutorGroup)DefaultCommunicationClient.this.defaultHandlerExecutorGroup, "MessageHandler", (ChannelHandler)new CommunicationAbstract.DefaultCommunicationMessageHandler());
            }
        });
        this.executor.scheduleAtFixedRate(new CommunicationAbstract.ScanResponseTableRunnable(), 3000L, 1000L, TimeUnit.MILLISECONDS);
        if (cleanExecutor.getActiveCount() == 0) {
            cleanExecutor.scheduleAtFixedRate(new ScanChannelTableTask(), 1L, 1L, TimeUnit.MINUTES);
        }
        if (this.channelEventExecutor != null) {
            this.channelEventExecutor.start();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.executor.shutdown();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.channelEventExecutor != null) {
                this.channelEventExecutor.shutdown();
            }
            if (this.defaultHandlerExecutorGroup != null) {
                this.defaultHandlerExecutorGroup.shutdownGracefully();
            }
            if (clientCountInSameJVM.decrementAndGet() == 0) {
                cleanExecutor.shutdown();
                cleanExecutor = null;
                if (heartBeatScheduledThreadPoolExecutor != null) {
                    heartBeatScheduledThreadPoolExecutor.shutdown();
                    heartBeatScheduledThreadPoolExecutor = null;
                }
            }
        }
        catch (Exception e) {
            this.logger.error("DefaultCommunicationClient shutdown exception, {}", (Object)e.toString());
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                this.logger.error("DefaultCommunicationClient shutdown exception, {}", (Object)e.toString());
            }
        }
    }

    @Override
    public void registerInvokeHook(InvokeHook invokeHook) {
        this.invokeHook = invokeHook;
    }

    @Override
    public CommunicationUnit invokeSync(String addr, CommunicationUnit request) throws CommunicationException, InterruptedException {
        return this.invokeSync(addr, request, this.communicationClientConfig.getInvokeSyncTimeout());
    }

    @Override
    public CommunicationUnit invokeSync(String addr, CommunicationUnit request, long timeout) throws CommunicationException, InterruptedException {
        try {
            ChannelWrapper channelWrapper = this.checkChannelConnection(addr);
            if (this.getInvokeHook() != null) {
                this.getInvokeHook().doBeforeRequest(addr, request);
            }
            CommunicationUnit response = this.invokeSyncImpl(channelWrapper.getChannel(), request, timeout <= 0L ? this.communicationClientConfig.getInvokeSyncTimeout() : timeout);
            if (this.getInvokeHook() != null) {
                this.getInvokeHook().doAfterResponse(addr, request, response);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.warn("Exception occurs when sending one sync request to the remote address {}, but got exception {}", (Object)addr, (Object)e.toString());
            if (this.communicationClientConfig.getCloseChannelAfterInvocationException()) {
                this.closeChannel(addr);
            }
            throw e;
        }
    }

    @Override
    public void invokeAsync(String addr, CommunicationUnit request, InvokeCallback invokeCallback) throws CommunicationException, InterruptedException {
        this.invokeAsync(addr, request, invokeCallback, this.communicationClientConfig.getInvokeAsyncTimeout());
    }

    @Override
    public void invokeAsync(String addr, CommunicationUnit request, InvokeCallback invokeCallback, long timeout) throws CommunicationException, InterruptedException {
        try {
            ChannelWrapper channelWrapper = this.checkChannelConnection(addr);
            if (this.getInvokeHook() != null) {
                this.getInvokeHook().doBeforeRequest(addr, request);
            }
            this.invokeAsyncImpl(channelWrapper.getChannel(), request, timeout <= 0L ? this.communicationClientConfig.getInvokeAsyncTimeout() : timeout, invokeCallback);
        }
        catch (Exception e) {
            this.logger.warn("Exception occurs when sending one async request to the remote address {}, but got exception {}", (Object)addr, (Object)e.toString());
            if (this.communicationClientConfig.getCloseChannelAfterInvocationException()) {
                this.closeChannel(addr);
            }
            throw e;
        }
    }

    @Override
    public void invokeOneway(String addr, CommunicationUnit request) throws CommunicationException, InterruptedException {
        try {
            ChannelWrapper channelWrapper = this.checkChannelConnection(addr);
            if (this.getInvokeHook() != null) {
                this.getInvokeHook().doBeforeRequest(addr, request);
            }
            this.invokeOneWayImpl(channelWrapper.getChannel(), request, this.communicationClientConfig.getInvokeOneWayTimeout());
        }
        catch (Exception e) {
            this.logger.warn("Exception occurs when sending one one way request to the remote address {}, but got exception {}", (Object)addr, (Object)e.toString());
            if (this.communicationClientConfig.getCloseChannelAfterInvocationException()) {
                this.closeChannel(addr);
            }
            throw e;
        }
    }

    private ChannelWrapper checkChannelConnection(String address) throws CommunicationException {
        ChannelWrapper channelWrapper = (ChannelWrapper)channelTables.get(address);
        if (channelWrapper == null || !channelWrapper.isChannelActive()) {
            channelWrapper = this.createChannel(address);
        }
        return channelWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelWrapper createChannel(String addr) throws CommunicationException {
        if (addr == null || "".equals(addr)) {
            throw new CommunicationException(String.format("The addr parameter should not be null %s", addr));
        }
        if (this.tryAcquireChannelLock("createChannel", addr)) {
            try {
                ChannelWrapper channelWrapper = (ChannelWrapper)channelTables.get(addr);
                if (channelWrapper != null && !channelWrapper.isChannelActive()) {
                    this.doCloseChannel(channelWrapper.getChannel(), null);
                    channelTables.remove(addr);
                } else if (channelWrapper != null && channelWrapper.isChannelActive()) {
                    ChannelWrapper channelWrapper2 = channelWrapper;
                    return channelWrapper2;
                }
                this.logger.info("Start creating one new Channel instance for the remote address {}.", (Object)addr);
                channelWrapper = new ChannelWrapper(this.doCreateChannel(addr), System.currentTimeMillis(), heartBeatScheduledThreadPoolExecutor, responseTable);
                channelTables.put(addr, channelWrapper);
                if (!channelWrapper.getChannel().isActive()) {
                    throw new CommunicationException(String.format("Failed to create a stable connection to the remote address %s.", addr));
                }
                channelWrapper.startHeartbeatService();
                ChannelWrapper channelWrapper3 = channelWrapper;
                return channelWrapper3;
            }
            finally {
                this.releaseChannelLock();
            }
        }
        throw new CommunicationTimeoutException(String.format("try acquire lock timeout when creating one new Channel instance for the remote address %s.", addr), this.communicationClientConfig.getConnectTimeoutMillis());
    }

    private Channel doCreateChannel(String addr) throws CommunicationException {
        ChannelFuture channelFuture = this.bootstrap.connect(CommunicationUtils.string2SocketAddress(addr));
        if (channelFuture.awaitUninterruptibly((long)this.communicationClientConfig.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS)) {
            this.logger.info("Succeeded creating the Channel instance for the remote address {}", (Object)addr);
            if (!channelFuture.channel().isActive()) {
                throw new CommunicationException(String.format("ChannelFuture has been completed, but the channel %s is still not active!", CommunicationUtils.parseChannelAddress(channelFuture.channel())));
            }
            return channelFuture.channel();
        }
        this.logger.warn("Creating a Channel instance for the remote address {} timeout.", (Object)addr);
        throw new CommunicationTimeoutException(String.format("Creating the Channel for the remote address %s timeout.", addr), this.communicationClientConfig.getConnectTimeoutMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeConnection(String addr) {
        if (this.tryAcquireChannelLock("closeConnection", addr)) {
            try {
                ChannelWrapper channelWrapper = (ChannelWrapper)channelTables.get(addr);
                boolean rs = false;
                if (channelWrapper != null) {
                    channelWrapper.shutdownHeartbeatService();
                    this.doCloseChannel(channelWrapper.getChannel(), null);
                    channelTables.remove(addr);
                    this.logger.info("closeChannel for remote address {}, and succeeded removing channel from the channel table.", (Object)CommunicationUtils.parseChannelAddress(channelWrapper.getChannel()));
                    rs = true;
                }
                boolean bl = rs;
                return bl;
            }
            finally {
                this.releaseChannelLock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel(String addr) {
        if (this.tryAcquireChannelLock("closeChannel", addr)) {
            try {
                ChannelWrapper channelWrapper = (ChannelWrapper)channelTables.get(addr);
                if (channelWrapper != null) {
                    channelWrapper.shutdownHeartbeatService();
                    String addressString = CommunicationUtils.parseChannelAddress(channelWrapper.getChannel());
                    this.doCloseChannel(channelWrapper.getChannel(), null);
                    channelTables.remove(addr);
                    this.logger.info("closeChannel for remote address {}, and succeeded removing channel from the channel table.", (Object)addressString);
                }
            }
            finally {
                this.releaseChannelLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel(ChannelWrapper channelWrapper) {
        if (channelWrapper == null) {
            return;
        }
        String addr = CommunicationUtils.parseChannelRemoteAddr(channelWrapper.getChannel());
        if (this.tryAcquireChannelLock("closeChannel", addr)) {
            try {
                for (Map.Entry entry : channelTables.entrySet()) {
                    if (((ChannelWrapper)entry.getValue()).getChannel() != channelWrapper.getChannel()) continue;
                    channelTables.remove(entry.getKey());
                    channelWrapper.shutdownHeartbeatService();
                    String addressString = CommunicationUtils.parseChannelAddress(channelWrapper.getChannel());
                    this.doCloseChannel(channelWrapper.getChannel(), null);
                    this.logger.info("closeChannel for remote address {}, and succeeded removing channel from the channel table.", (Object)addressString);
                    break;
                }
            }
            finally {
                this.releaseChannelLock();
            }
        }
    }

    private void doCloseChannel(Channel channel, ChannelFutureListener channelFutureListener) {
        if (channelFutureListener != null) {
            channel.close().addListener((GenericFutureListener)channelFutureListener);
        } else {
            channel.close();
        }
    }

    private boolean tryAcquireChannelLock(String action, String address) {
        try {
            if (this.channelLock.tryLock(this.communicationClientConfig.getConnectTimeoutMillis(), TimeUnit.MILLISECONDS)) {
                return true;
            }
            this.logger.warn("try acquire lock timeout when {} for remote address {}.", (Object)action, (Object)address);
            return false;
        }
        catch (InterruptedException e) {
            this.logger.warn("Exception occurs when {} for remote address {}, got exception {}.", new Object[]{action, address, e.toString()});
            return false;
        }
    }

    private void releaseChannelLock() {
        this.channelLock.unlock();
    }

    @Override
    public void registerHandler(short requestCode, CommunicationRequestHandler handler, ExecutorService executor) {
        ExecutorService executorService = executor;
        if (executorService == null) {
            executorService = this.publicExecutor;
        }
        Pair<CommunicationRequestHandler, ExecutorService> pair = new Pair<CommunicationRequestHandler, ExecutorService>(handler, executorService);
        this.handlerTable.put(requestCode, pair);
    }

    @Override
    public boolean isChannelWriteable(String addr) {
        boolean rs = false;
        ChannelWrapper channelWrapper = (ChannelWrapper)channelTables.get(addr);
        if (channelWrapper != null && channelWrapper.isChannelActive()) {
            rs = channelWrapper.isChannelWritable();
        }
        return rs;
    }

    @Override
    protected ChannelWrapper getChannelWrapperByChannel(Channel channel) {
        ChannelWrapper rs = null;
        if (channel != null) {
            for (Map.Entry entry : channelTables.entrySet()) {
                if (((ChannelWrapper)entry.getValue()).getChannel() != channel) continue;
                rs = (ChannelWrapper)entry.getValue();
                break;
            }
            if (rs == null) {
                String channelAddress = CommunicationUtils.parseChannelAddress(channel);
                rs = new ChannelWrapper(channel, System.currentTimeMillis(), heartBeatScheduledThreadPoolExecutor, responseTable);
                String newChannelWrapperString = rs.toString();
                this.logger.info("A new ChannelWrapper instance {} has been created for the unregistered channel {}", (Object)newChannelWrapperString, (Object)channelAddress);
            }
        } else {
            this.logger.warn("The provided Channel instance parameter is null!");
        }
        return rs;
    }

    static {
        clientCountInSameJVM = new AtomicInteger(0);
    }

    protected class DefaultClientConnectManageHandler
    extends ChannelDuplexHandler {
        protected DefaultClientConnectManageHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteSocketAddress, SocketAddress localSocketAddress, ChannelPromise promise) throws Exception {
            String remoteAddress = remoteSocketAddress == null ? "unknown" : CommunicationUtils.parseSocketAddressAddr(remoteSocketAddress);
            String localAddress = localSocketAddress == null ? "unknown" : CommunicationUtils.parseSocketAddressAddr(localSocketAddress);
            DefaultCommunicationClient.this.logger.info("Communication Client Pipeline: Connect {} => {}", (Object)localAddress, (Object)remoteAddress);
            super.connect(ctx, remoteSocketAddress, localSocketAddress, promise);
            ChannelWrapper channelWrapper = DefaultCommunicationClient.this.getChannelWrapperByChannel(ctx.channel());
            if (DefaultCommunicationClient.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                DefaultCommunicationClient.this.putChannelEvent(new ChannelEvent(ChannelEventType.CONNECT, remoteAddress, channelWrapper));
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationClient.this.logger.info("Communication Client Pipeline: Disconnect {}", (Object)remoteAddress);
            super.disconnect(ctx, promise);
            ChannelWrapper channelWrapper = DefaultCommunicationClient.this.getChannelWrapperByChannel(ctx.channel());
            if (DefaultCommunicationClient.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                DefaultCommunicationClient.this.putChannelEvent(new ChannelEvent(ChannelEventType.CLOSE, remoteAddress, channelWrapper));
            }
            DefaultCommunicationClient.this.closeChannel(channelWrapper);
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationClient.this.logger.info("Communication Client Pipeline: Close {}", (Object)remoteAddress);
            super.close(ctx, promise);
            ChannelWrapper channelWrapper = DefaultCommunicationClient.this.getChannelWrapperByChannel(ctx.channel());
            if (DefaultCommunicationClient.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                DefaultCommunicationClient.this.putChannelEvent(new ChannelEvent(ChannelEventType.CLOSE, remoteAddress, channelWrapper));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof IdleStateEvent) {
                IdleStateEvent event = (IdleStateEvent)evt;
                String remoteAddress = CommunicationUtils.parseSocketAddressAddr(ctx.channel().remoteAddress());
                ChannelWrapper channelWrapper = DefaultCommunicationClient.this.getChannelWrapperByChannel(ctx.channel());
                ChannelEventType cet = ChannelEventType.ALL_IDLE;
                if (event.state().equals((Object)IdleState.ALL_IDLE)) {
                    DefaultCommunicationClient.this.logger.info("Communication Client Pipeline: ALL_IDLE idle state event {}", (Object)remoteAddress);
                    cet = ChannelEventType.ALL_IDLE;
                } else if (event.state().equals((Object)IdleState.READER_IDLE)) {
                    DefaultCommunicationClient.this.logger.info("Communication Client Pipeline: READER_IDLE idle state event {}", (Object)remoteAddress);
                    cet = ChannelEventType.READ_IDLE;
                } else if (event.state().equals((Object)IdleState.WRITER_IDLE)) {
                    DefaultCommunicationClient.this.logger.info("Communication Client Pipeline: WRITER_IDLE idle state event {}", (Object)remoteAddress);
                    cet = ChannelEventType.WRITE_IDLE;
                }
                if (DefaultCommunicationClient.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                    DefaultCommunicationClient.this.putChannelEvent(new ChannelEvent(cet, remoteAddress, channelWrapper));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = CommunicationUtils.parseChannelRemoteAddr(ctx.channel());
            DefaultCommunicationClient.this.logger.warn("Communication Client Pipeline: ExceptionCaught {} from the channel to the remote address {}", cause != null ? cause : "", (Object)remoteAddress);
            ChannelWrapper channelWrapper = DefaultCommunicationClient.this.getChannelWrapperByChannel(ctx.channel());
            if (DefaultCommunicationClient.this.getDefaultChannelEventListener() != null || channelWrapper.getChannelEventListener() != null) {
                DefaultCommunicationClient.this.putChannelEvent(new ChannelEvent(ChannelEventType.EXCEPTION, remoteAddress, channelWrapper));
            }
            DefaultCommunicationClient.this.closeChannel(channelWrapper);
        }
    }

    protected class ScanChannelTableTask
    implements Runnable {
        protected ScanChannelTableTask() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : channelTables.entrySet()) {
                ChannelWrapper channelWrapper;
                if (((ChannelWrapper)entry.getValue()).isChannelActive() || (channelWrapper = (ChannelWrapper)channelTables.remove(entry.getKey())) == null) continue;
                channelWrapper.shutdownHeartbeatService();
            }
        }
    }
}

