/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.protocol;

public enum CommunicationType {
    ONE_WAY_REQUEST(0),
    SYNC_REQUEST(1),
    ASYNC_REQUEST(2),
    ONE_WAY_RESPONSE(3),
    SYNC_RESPONSE(4),
    ASYNC_RESPONSE(5);

    private byte code;

    private CommunicationType(byte code) {
        this.code = code;
    }

    public static CommunicationType valueOf(byte code) {
        for (CommunicationType communicationType : CommunicationType.values()) {
            if (communicationType.getCode() != code) continue;
            return communicationType;
        }
        return null;
    }

    public static boolean isRequest(byte code) {
        CommunicationType ct = CommunicationType.valueOf(code);
        if (ct == null) {
            return false;
        }
        return ct == ONE_WAY_REQUEST || ct == SYNC_REQUEST || ct == ASYNC_REQUEST;
    }

    public static boolean isResponse(byte code) {
        CommunicationType ct = CommunicationType.valueOf(code);
        if (ct == null) {
            return false;
        }
        return ct == ONE_WAY_RESPONSE || ct == SYNC_RESPONSE || ct == ASYNC_RESPONSE;
    }

    public static CommunicationType getResponseByRequest(CommunicationType request) {
        if (CommunicationType.isResponse(request.getCode())) {
            return request;
        }
        return CommunicationType.valueOf((byte)(request.getCode() + 3));
    }

    public static CommunicationType getRequestByResponse(CommunicationType response) {
        if (CommunicationType.isRequest(response.getCode())) {
            return response;
        }
        return CommunicationType.valueOf((byte)(response.getCode() - 3));
    }

    public byte getCode() {
        return this.code;
    }
}

