/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.communication.protocol;

import com.jcloud.jcq.common.client.ClientType;
import com.jcloud.jcq.common.utils.StringBuilderWrapper;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.common.utils.ThreadLocalStringBuilderUtils;
import com.jcloud.jcq.communication.exception.CommunicationUnitException;
import com.jcloud.jcq.communication.protocol.CommunicationType;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationUnit {
    private final Logger logger = LoggerFactory.getLogger((String)"JcqCommunication");
    private static AtomicInteger requestNumberSeed = new AtomicInteger(0);
    private int requestNumber = -1;
    private CommunicationType communicationType;
    private ClientType clientType;
    private short code;
    private transient byte[] data;
    private transient ByteBuffer pooledBufferRequest;
    private static final int HEADER_LENGTH_IN_BYTE = 8;
    private transient ByteBuffer[] dataByteBuffer;
    private static ConcurrentLinkedQueue<ByteBuffer> linkedBufferPool = new ConcurrentLinkedQueue();
    private static int DEAULT_MAX_POOL_SIZE = 64;
    private static int DEFAULT_BYTEBUFFER_SZIE = 65536;
    private static AtomicInteger queueSize = new AtomicInteger(0);
    private static AtomicInteger bufferPoolSize = new AtomicInteger(0);
    private AtomicBoolean isReleasePooledRequest = new AtomicBoolean(false);

    protected CommunicationUnit() {
    }

    public static int createNewRequestNumber() {
        return requestNumberSeed.incrementAndGet();
    }

    public static CommunicationUnit createHeartbeatRequestCommunicationUnit() {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setRequestNumber(CommunicationUnit.createNewRequestNumber());
        cu.setCode((short)100);
        cu.setClientType(ClientType.JAVA);
        cu.setCommunicationType(CommunicationType.SYNC_REQUEST);
        return cu;
    }

    public static CommunicationUnit createRequestCommunicationUnit(short requestCode, ClientType clientType, CommunicationType ct) {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setRequestNumber(CommunicationUnit.createNewRequestNumber());
        cu.setCode(requestCode);
        cu.setClientType(clientType);
        cu.setCommunicationType(ct);
        return cu;
    }

    public static CommunicationUnit createResponseCommunicationUnit(short responseCode, CommunicationType ct) {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setCode(responseCode);
        cu.setCommunicationType(ct);
        return cu;
    }

    public static CommunicationUnit createResponseCommunicationUnit(int requestNumber, short responseCode, CommunicationType ct) {
        CommunicationUnit cu = new CommunicationUnit();
        cu.setRequestNumber(requestNumber);
        cu.setCode(responseCode);
        cu.setCommunicationType(ct);
        return cu;
    }

    public static CommunicationUnit decodeFromByteArray(byte[] array) throws CommunicationUnitException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(array);
        return CommunicationUnit.decodeFromByteBuffer(byteBuffer);
    }

    public static CommunicationUnit decodeFromByteBuffer(ByteBuffer byteBuffer) throws CommunicationUnitException {
        int oriBodyLength = byteBuffer.getInt();
        int bodyLength = oriBodyLength & 0xFFFFFF;
        byte[] headerData = new byte[8];
        byteBuffer.get(headerData);
        CommunicationUnit cu = CommunicationUnit.decodeHeaderFromByteArray(headerData);
        byte[] bodyData = null;
        if (bodyLength > 0) {
            bodyData = new byte[bodyLength];
            byteBuffer.get(bodyData);
        }
        cu.setData(bodyData);
        return cu;
    }

    public static CommunicationUnit decodeRequestToPoolBuffer(ByteBuffer byteBuffer) throws CommunicationUnitException {
        int oriBodyLength = byteBuffer.getInt();
        int bodyLength = oriBodyLength & 0xFFFFFF;
        byte[] headerData = new byte[8];
        byteBuffer.get(headerData);
        CommunicationUnit cu = CommunicationUnit.decodeHeaderFromByteArray(headerData);
        if (bodyLength > 0) {
            if (CommunicationType.isRequest(cu.getCommunicationType().getCode())) {
                ByteBuffer body = CommunicationUnit.getPooledByteBuffer(bodyLength);
                byteBuffer.limit(byteBuffer.position() + bodyLength);
                body.put(byteBuffer);
                body.flip();
                cu.setPooledBufferRequest(body);
            } else {
                byte[] bodyData = new byte[bodyLength];
                byteBuffer.get(bodyData);
                cu.setData(bodyData);
            }
        }
        return cu;
    }

    private static CommunicationUnit decodeHeaderFromByteArray(byte[] headerArray) throws CommunicationUnitException {
        if (headerArray.length < 8) {
            throw new CommunicationUnitException(String.format("The header byte array's length is invalid, length: %d", headerArray.length));
        }
        CommunicationUnit cu = new CommunicationUnit();
        ByteBuffer headerBuffer = ByteBuffer.wrap(headerArray);
        cu.setCommunicationType(CommunicationType.valueOf(headerBuffer.get()));
        cu.setClientType(ClientType.valueOf(headerBuffer.get()));
        cu.setCode(headerBuffer.getShort());
        cu.setRequestNumber(headerBuffer.getInt());
        return cu;
    }

    public static ByteBuffer encode2ByteBuffer(CommunicationUnit communicationUnit) {
        int length = 4;
        byte[] headerData = communicationUnit.encodeHeader2ByteArray();
        length += headerData.length;
        if (communicationUnit.getData() != null) {
            length += communicationUnit.getData().length;
        }
        ByteBuffer result = ByteBuffer.allocate(length);
        result.putInt(communicationUnit.getData() == null ? 0 : communicationUnit.getData().length);
        result.put(headerData);
        if (communicationUnit.getData() != null) {
            result.put(communicationUnit.getData());
        }
        result.flip();
        return result;
    }

    public byte[] encodeHeader2ByteArray() {
        ByteBuffer headerBuffer = ByteBuffer.allocate(8);
        headerBuffer.put(this.getCommunicationType().getCode());
        headerBuffer.put(this.getClientType().getCode());
        headerBuffer.putShort(this.getCode());
        headerBuffer.putInt(this.getRequestNumber());
        return headerBuffer.array();
    }

    public int getRequestNumber() {
        return this.requestNumber;
    }

    public void setRequestNumber(int requestNumber) {
        this.requestNumber = requestNumber;
    }

    public CommunicationType getCommunicationType() {
        return this.communicationType;
    }

    public void setCommunicationType(CommunicationType communicationType) {
        this.communicationType = communicationType;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public short getCode() {
        return this.code;
    }

    public void setCode(short code) {
        this.code = code;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public ByteBuffer[] getDataByteBuffer() {
        return this.dataByteBuffer;
    }

    public void setDataByteBuffer(ByteBuffer[] dataByteBuffer) {
        this.dataByteBuffer = dataByteBuffer;
    }

    public ByteBuffer getPooledBufferRequest() {
        if (!this.isReleasePooledRequest.get()) {
            return this.pooledBufferRequest;
        }
        return null;
    }

    public void setPooledBufferRequest(ByteBuffer pooledBufferRequest) {
        this.pooledBufferRequest = pooledBufferRequest;
    }

    private static ByteBuffer getPooledByteBuffer(int size) {
        if (size > DEFAULT_BYTEBUFFER_SZIE) {
            return ByteBuffer.allocate(size);
        }
        ByteBuffer byteBuffer = linkedBufferPool.poll();
        if (byteBuffer != null) {
            queueSize.decrementAndGet();
            return byteBuffer;
        }
        if (bufferPoolSize.get() < DEAULT_MAX_POOL_SIZE) {
            byteBuffer = ByteBuffer.allocate(DEFAULT_BYTEBUFFER_SZIE);
            bufferPoolSize.incrementAndGet();
        } else {
            byteBuffer = ByteBuffer.allocate(size);
        }
        return byteBuffer;
    }

    public void releasePooledBufferRequest() {
        if (this.pooledBufferRequest == null) {
            return;
        }
        ByteBuffer byteBuffer = this.pooledBufferRequest;
        if (this.isReleasePooledRequest.compareAndSet(false, true) && byteBuffer != null && byteBuffer.capacity() == DEFAULT_BYTEBUFFER_SZIE) {
            if (queueSize.incrementAndGet() < DEAULT_MAX_POOL_SIZE) {
                byteBuffer.clear();
                linkedBufferPool.add(byteBuffer);
            } else {
                queueSize.decrementAndGet();
            }
        }
        this.pooledBufferRequest = null;
    }

    public AtomicBoolean getIsReleasePooledRequest() {
        return this.isReleasePooledRequest;
    }

    public void setIsReleasePooledRequest(boolean isReleased) {
        this.isReleasePooledRequest.set(isReleased);
    }

    public String toString() {
        HashMap<String, String> kvmap = new HashMap<String, String>();
        kvmap.put("RequestNumber", Integer.toString(this.getRequestNumber()));
        kvmap.put("CommunicationType", this.getCommunicationType() != null ? Byte.toString(this.getCommunicationType().getCode()) : "null");
        kvmap.put("ClientType", this.getClientType() != null ? Byte.toString(this.getClientType().getCode()) : "null");
        kvmap.put("RequestCode", Short.toString(this.getCode()));
        return StringUtils.toStringHelper(this.getClass().getName(), kvmap);
    }

    public StringBuilderWrapper toStringBuilderWrapper() {
        return ThreadLocalStringBuilderUtils.append(this.getClass().getName()).append("-[").append("RequestNumber=").append(this.getRequestNumber()).append(",CommunicationType=").append(this.getCommunicationType().getCode()).append(",ClientType=").append(this.getClientType().getCode()).append(",RequestCode=").append(this.getCode()).append("]");
    }
}

