/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtobufIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;

public class ProtocolSerializer {
    private static ConcurrentMap<Class<?>, Schema<?>> classSchemaMap = new ConcurrentHashMap();
    private static LinkedBlockingDeque<LinkedBuffer> linkedBufferPool = new LinkedBlockingDeque(1024);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] encode(T object) {
        if (object == null) {
            return null;
        }
        LinkedBuffer linkedBuffer = linkedBufferPool.poll();
        if (linkedBuffer == null) {
            linkedBuffer = LinkedBuffer.allocate((int)512);
        }
        try {
            byte[] byArray = ProtobufIOUtil.toByteArray(object, ProtocolSerializer.schemaOf(object.getClass()), (LinkedBuffer)linkedBuffer);
            return byArray;
        }
        finally {
            linkedBuffer.clear();
            linkedBufferPool.offer(linkedBuffer);
        }
    }

    public static <T> T decode(byte[] data, Class<T> destClass) {
        if (data == null || data.length == 0) {
            return null;
        }
        Schema<T> schema = ProtocolSerializer.schemaOf(destClass);
        Object object = ProtocolSerializer.schemaOf(destClass).newMessage();
        ProtobufIOUtil.mergeFrom((byte[])data, (Object)object, schema);
        return (T)object;
    }

    public static <T> T decode(ByteBuffer byteBuffer, Class<T> destClass) {
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            return null;
        }
        Schema<T> schema = ProtocolSerializer.schemaOf(destClass);
        Object object = ProtocolSerializer.schemaOf(destClass).newMessage();
        ProtobufIOUtil.mergeFrom((byte[])byteBuffer.array(), (int)byteBuffer.position(), (int)byteBuffer.remaining(), (Object)object, schema);
        return (T)object;
    }

    private static <T> Schema<T> schemaOf(Class<T> tClass) {
        Schema schema = (Schema)classSchemaMap.get(tClass);
        if (schema == null) {
            schema = RuntimeSchema.createFrom(tClass);
            classSchemaMap.put(tClass, schema);
        }
        return schema;
    }
}

