/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol;

import com.jcloud.jcq.common.auth.Auth;
import com.jcloud.jcq.common.utils.SignUtils;
import com.jcloud.jcq.common.utils.StringBuilderWrapper;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.common.utils.ThreadLocalStringBuilderUtils;
import com.jcloud.jcq.protocol.SignSourceGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Request {
    public static final String ACCESS_KEY = "accessKey";
    public static final String SIGNATURE = "signature";
    public static final String JCLOUD_TOKEN = "jcloudToken";
    protected String requestId = UUID.randomUUID().toString();
    protected String version;
    protected short requestCode;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected long createTimestamp = System.currentTimeMillis();

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public short getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(short requestCode) {
        this.requestCode = requestCode;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public String getAccessKey() {
        return this.properties.get(ACCESS_KEY);
    }

    public void setAccessKey(String accessKey) {
        this.properties.put(ACCESS_KEY, accessKey);
    }

    public String getSignature() {
        return this.properties.get(SIGNATURE);
    }

    public void setSignature(String signature) {
        this.properties.put(SIGNATURE, signature);
    }

    public String getJcloudToken() {
        return this.properties.get(JCLOUD_TOKEN);
    }

    public void setJcloudToken(String token) {
        this.properties.put(JCLOUD_TOKEN, token);
    }

    public String toString() {
        return "Request{requestId='" + this.requestId + '\'' + ",version='" + this.version + '\'' + ",requestCode=" + this.requestCode + ",properties=" + this.properties + ",createTimestamp=" + this.createTimestamp + '}';
    }

    public StringBuilderWrapper toStringBuilderWrapper() {
        return ThreadLocalStringBuilderUtils.append("Request{").append("req=").append(this.requestId).append(",ver=").append(this.version).append(",rcd=").append(this.requestCode).append(",ppt=").append(this.properties).append(",ctt=").append(this.createTimestamp).append(Character.valueOf('}'));
    }

    public String validate() {
        return null;
    }

    public boolean needAuth() {
        Auth auth = this.getClass().getAnnotation(Auth.class);
        return auth != null;
    }

    public boolean innerRequest() {
        Auth auth = this.getClass().getAnnotation(Auth.class);
        return auth != null && auth.scope() == Auth.Scope.INNER;
    }

    public void sign(String secretKey) throws Exception {
        this.setSignature(SignUtils.signWithHmacSha1(SignSourceGenerator.getSignSource(this), secretKey));
    }

    public boolean auth(String secretKey) throws Exception {
        if (!this.needAuth()) {
            return true;
        }
        return !StringUtils.isEmpty(this.getSignature()) && this.getSignature().equals(SignUtils.signWithHmacSha1(SignSourceGenerator.getSignSource(this), secretKey));
    }
}

