/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol;

import com.jcloud.jcq.protocol.Request;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignSourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SignSourceGenerator.class);
    private static ConcurrentMap<Class, ConcurrentMap<String, PropertyDescriptor>> propertyDescriptorMap = new ConcurrentHashMap<Class, ConcurrentMap<String, PropertyDescriptor>>();

    public static String getSignSource(Request request) {
        if (request == null) {
            return null;
        }
        ConcurrentHashMap<String, PropertyDescriptor> propertyDescriptors = (ConcurrentHashMap<String, PropertyDescriptor>)propertyDescriptorMap.get(request.getClass());
        if (propertyDescriptors == null) {
            try {
                PropertyDescriptor[] descriptors;
                propertyDescriptors = new ConcurrentHashMap<String, PropertyDescriptor>();
                for (PropertyDescriptor descriptor : descriptors = Introspector.getBeanInfo(request.getClass(), Object.class).getPropertyDescriptors()) {
                    propertyDescriptors.put(descriptor.getName(), descriptor);
                }
                propertyDescriptorMap.put(request.getClass(), propertyDescriptors);
            }
            catch (IntrospectionException e) {
                logger.warn("got exception:{} when get property descriptors of class:{}", (Object)e, (Object)request.getClass().getSimpleName());
                return null;
            }
        }
        TreeMap<String, String> fieldValueMap = new TreeMap<String, String>();
        fieldValueMap.putAll(request.getProperties());
        for (Map.Entry entry : propertyDescriptors.entrySet()) {
            Object fieldValue;
            String fieldName = (String)entry.getKey();
            if (fieldName.equals("properties") || fieldName.equals("jcloudToken")) continue;
            Method readMethod = ((PropertyDescriptor)entry.getValue()).getReadMethod();
            readMethod.setAccessible(true);
            try {
                fieldValue = readMethod.invoke((Object)request, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn("got exception:{} when invoke method:{} on request:{}", new Object[]{e, readMethod.getName(), request});
                continue;
            }
            fieldValueMap.put(fieldName, fieldValue == null ? "" : fieldValue.toString());
        }
        fieldValueMap.remove("signature");
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : fieldValueMap.entrySet()) {
            stringBuilder.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        return stringBuilder.toString();
    }
}

