/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.protocol.client;

import com.jcloud.jcq.common.message.MessageType;
import com.jcloud.jcq.common.utils.StringBuilderWrapper;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.common.utils.ThreadLocalStringBuilderUtils;
import com.jcloud.jcq.protocol.Message;
import com.jcloud.jcq.protocol.Request;
import com.jcloud.jcq.protocol.ToStringHelper;
import java.util.List;

public class SendMessageRequest
extends Request {
    protected String topic;
    protected long createTime;
    protected List<Message> messages;
    protected MessageType messageType = MessageType.NORMAL;
    protected int queueId = -1;

    public SendMessageRequest() {
        this.requestCode = (short)101;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public void setQueueId(int queueId) {
        this.queueId = queueId;
    }

    @Override
    public String validate() {
        String result = super.validate();
        if (!StringUtils.isEmpty(result)) {
            return result;
        }
        if (StringUtils.isEmpty(this.getAccessKey())) {
            return "accessKey is null";
        }
        if (StringUtils.isEmpty(this.topic)) {
            return "topic is empty";
        }
        if (this.messages == null || this.messages.isEmpty()) {
            return "messages is empty";
        }
        if (this.messageType == null) {
            return "messageType is null";
        }
        if (this.queueId < -1) {
            return "queueId is invalid";
        }
        return null;
    }

    @Override
    public String toString() {
        return "SendMessageRequest{requestId='" + this.requestId + '\'' + ",version='" + this.version + '\'' + ",requestCode=" + this.requestCode + ",properties=" + this.properties + ",createTimestamp=" + this.createTimestamp + ",topic='" + this.topic + '\'' + ",messages=" + ToStringHelper.simpleMessagesToString(this.messages) + ",messageType=" + (Object)((Object)this.messageType) + ",queueId=" + this.queueId + "}";
    }

    @Override
    public StringBuilderWrapper toStringBuilderWrapper() {
        ThreadLocalStringBuilderUtils.append("SendMessageRequest{").append(this.requestId).append("|").append(this.version).append("|").append(this.requestCode).append("|").append((Object)this.properties).append("|").append(this.createTimestamp).append("|").append(this.topic).append(",messages=");
        ToStringHelper.messagesToBuilderWrapper(this.messages);
        return ThreadLocalStringBuilderUtils.append(",messageType=").append((Object)this.messageType).append(",queueId=").append(this.queueId).append("}");
    }
}

