/*
 * Decompiled with CFR 0.152.
 */
package com.jcloud.jcq.sdk.consumer.impl;

import com.jcloud.jcq.client.Exception.ClientException;
import com.jcloud.jcq.common.filter.FilterExpression;
import com.jcloud.jcq.common.message.AckAction;
import com.jcloud.jcq.common.utils.StringUtils;
import com.jcloud.jcq.protocol.Message;
import com.jcloud.jcq.protocol.client.AckMessageResponse;
import com.jcloud.jcq.protocol.client.PullMessageResponse;
import com.jcloud.jcq.sdk.consumer.PullConsumer;
import com.jcloud.jcq.sdk.consumer.async.AsyncAckCallback;
import com.jcloud.jcq.sdk.consumer.async.AsyncPullCallback;
import com.jcloud.jcq.sdk.consumer.model.AckResult;
import com.jcloud.jcq.sdk.consumer.model.PullResult;
import com.jcloud.jcq.sdk.producer.model.ResultCode;
import java.util.List;

public class DefaultPullConsumerImpl
implements PullConsumer {
    private com.jcloud.jcq.client.consumer.PullConsumer pullConsumer;
    private static final String JOINT = "|";
    private static final String BACKSLASH_JOINT = "\\|";

    public DefaultPullConsumerImpl(com.jcloud.jcq.client.consumer.PullConsumer pullConsumer) {
        this.pullConsumer = pullConsumer;
    }

    @Override
    public PullResult pullMessage(String topic, FilterExpression filterExpression) throws ClientException {
        PullMessageResponse response = this.pullConsumer.pullMessage(topic, filterExpression);
        if (response.success()) {
            List<Message> messages;
            return new PullResult(ResultCode.SUCCESS, messages, (messages = response.getMessages()) == null || messages.isEmpty() ? null : messages.get(0).getQueueId() + JOINT + response.getAckIndex());
        }
        return new PullResult(ResultCode.FAILED, null, null);
    }

    @Override
    public void pullMessageAsync(String topic, FilterExpression filterExpression, final AsyncPullCallback callback) throws ClientException {
        this.pullConsumer.pullMessageAsync(topic, filterExpression, new com.jcloud.jcq.client.consumer.AsyncPullCallback(){

            @Override
            public void onResponse(PullMessageResponse response) {
                if (response.success()) {
                    List<Message> messages;
                    callback.onResult(new PullResult(ResultCode.SUCCESS, messages, (messages = response.getMessages()) == null || messages.isEmpty() ? null : messages.get(0).getQueueId() + DefaultPullConsumerImpl.JOINT + response.getAckIndex()));
                } else {
                    callback.onResult(new PullResult(ResultCode.FAILED, null, null));
                }
            }

            @Override
            public void onException(Throwable throwable) {
                callback.onException(throwable);
            }
        });
    }

    @Override
    public AckResult ackMessage(String topic, String ackIndex, AckAction ackAction) throws ClientException {
        String[] strings = this.parseAckIndex(ackIndex);
        AckMessageResponse response = this.pullConsumer.ackMessage(topic, this.getAckIndex(strings), ackAction, this.getQueueId(strings));
        return response.success() ? new AckResult(ResultCode.SUCCESS) : new AckResult(ResultCode.FAILED);
    }

    @Override
    public void ackMessageAsync(String topic, String ackIndex, AckAction ackAction, final AsyncAckCallback callback) throws ClientException {
        String[] strings = this.parseAckIndex(ackIndex);
        this.pullConsumer.ackMessageAsync(topic, this.getAckIndex(strings), ackAction, new com.jcloud.jcq.client.consumer.AsyncAckCallback(){

            @Override
            public void onResponse(AckMessageResponse response) {
                callback.onResult(response.success() ? new AckResult(ResultCode.SUCCESS) : new AckResult(ResultCode.FAILED));
            }

            @Override
            public void onException(Throwable throwable) {
                callback.onException(throwable);
            }
        }, this.getQueueId(strings));
    }

    @Override
    public void start() throws ClientException {
        this.pullConsumer.start();
    }

    @Override
    public void shutdown() throws ClientException {
        this.pullConsumer.shutdown();
    }

    private String[] parseAckIndex(String ackIndex) throws ClientException {
        if (StringUtils.isEmpty(ackIndex)) {
            throw new ClientException("ackIndex is empty.");
        }
        String[] strings = ackIndex.split(BACKSLASH_JOINT);
        if (strings.length != 2 || Integer.valueOf(strings[0]) < 0 || Long.valueOf(strings[1]) < 0L) {
            throw new ClientException(String.format("ackIndex[%s] is invalid.", ackIndex));
        }
        return strings;
    }

    private Long getAckIndex(String[] strings) {
        return Long.valueOf(strings[1]);
    }

    private Integer getQueueId(String[] strings) {
        return Integer.valueOf(strings[0]);
    }
}

