/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batch;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters supplied to the RegenerateKey operation.
 */
public class BatchAccountRegenerateKeyParameters {
    /**
     * The type of account key to regenerate. Possible values include:
     * 'Primary', 'Secondary'.
     */
    @JsonProperty(value = "keyName", required = true)
    private AccountKeyType keyName;

    /**
     * Get the keyName value.
     *
     * @return the keyName value
     */
    public AccountKeyType keyName() {
        return this.keyName;
    }

    /**
     * Set the keyName value.
     *
     * @param keyName the keyName value to set
     * @return the BatchAccountRegenerateKeyParameters object itself.
     */
    public BatchAccountRegenerateKeyParameters withKeyName(AccountKeyType keyName) {
        this.keyName = keyName;
        return this;
    }

}
