/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * IP address for the group.
 */
public class IpAddress {
    /**
     * The ports.
     */
    @JsonProperty(value = "ports", required = true)
    private List<Port> ports;

    /**
     * Determines whether the IP is exposed to the public internet.
     */
    @JsonProperty(value = "type", required = true)
    private String type;

    /**
     * The IP exposed to the public internet.
     */
    @JsonProperty(value = "ip")
    private String ip;

    /**
     * Creates an instance of IpAddress class.
     */
    public IpAddress() {
        type = "Public";
    }

    /**
     * Get the ports value.
     *
     * @return the ports value
     */
    public List<Port> ports() {
        return this.ports;
    }

    /**
     * Set the ports value.
     *
     * @param ports the ports value to set
     * @return the IpAddress object itself.
     */
    public IpAddress withPorts(List<Port> ports) {
        this.ports = ports;
        return this;
    }

    /**
     * Get the type value.
     *
     * @return the type value
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type value.
     *
     * @param type the type value to set
     * @return the IpAddress object itself.
     */
    public IpAddress withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the ip value.
     *
     * @return the ip value
     */
    public String ip() {
        return this.ip;
    }

    /**
     * Set the ip value.
     *
     * @param ip the ip value to set
     * @return the IpAddress object itself.
     */
    public IpAddress withIp(String ip) {
        this.ip = ip;
        return this;
    }

}
