/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.containerinstance;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Defines values for OperatingSystemTypes.
 */
public final class OperatingSystemTypes {
    /** Static value Windows for OperatingSystemTypes. */
    public static final OperatingSystemTypes WINDOWS = new OperatingSystemTypes("Windows");

    /** Static value Linux for OperatingSystemTypes. */
    public static final OperatingSystemTypes LINUX = new OperatingSystemTypes("Linux");

    private String value;

    /**
     * Creates a custom value for OperatingSystemTypes.
     * @param value the custom value
     */
    public OperatingSystemTypes(String value) {
        this.value = value;
    }

    @JsonValue
    @Override
    public String toString() {
        return value;
    }

    @Override
    public int hashCode() {
        return value.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OperatingSystemTypes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        OperatingSystemTypes rhs = (OperatingSystemTypes) obj;
        if (value == null) {
            return rhs.value == null;
        } else {
            return value.equals(rhs.value);
        }
    }
}
