/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.containerinstance.Container;
import com.microsoft.azure.management.containerinstance.ContainerRestartPolicy;
import com.microsoft.azure.management.containerinstance.OperatingSystemTypes;
import com.microsoft.azure.management.containerinstance.Port;
import com.microsoft.azure.management.containerinstance.Volume;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import java.util.Collection;
import java.util.Map;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_3_0)
public interface ContainerGroup
extends GroupableResource<ContainerInstanceManager, ContainerGroupInner>,
Refreshable<ContainerGroup> {
    public Map<String, Container> containers();

    public Collection<Port> externalPorts();

    public int[] externalTcpPorts();

    public int[] externalUdpPorts();

    public Map<String, Volume> volumes();

    public Collection<String> imageRegistryServers();

    public ContainerRestartPolicy restartPolicy();

    public String ipAddress();

    public boolean isIPAddressPublic();

    public OperatingSystemTypes osType();

    public String state();

    public String provisioningState();

    public String getLogContent(String var1);

    public String getLogContent(String var1, int var2);

    public Observable<String> getLogContentAsync(String var1);

    public Observable<String> getLogContentAsync(String var1, int var2);

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ContainerGroup>,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface ContainerInstanceDefinitionStages {

            public static interface ContainerInstanceDefinition<ParentT>
            extends ContainerInstanceDefinitionBlank<ParentT>,
            WithImage<ParentT>,
            WithOrWithoutPorts<ParentT>,
            WithPortsOrContainerInstanceAttach<ParentT>,
            WithContainerInstanceAttach<ParentT> {
            }

            public static interface WithContainerInstanceAttach<ParentT>
            extends WithCpuCoreCount<ParentT>,
            WithMemorySize<ParentT>,
            WithStartingCommandLine<ParentT>,
            WithEnvironmentVariables<ParentT>,
            WithVolumeMountSetting<ParentT>,
            Attachable.InDefinition<ParentT> {
            }

            public static interface WithVolumeMountSetting<ParentT> {
                public WithContainerInstanceAttach<ParentT> withVolumeMountSetting(String var1, String var2);

                public WithContainerInstanceAttach<ParentT> withVolumeMountSetting(Map<String, String> var1);

                public WithContainerInstanceAttach<ParentT> withReadOnlyVolumeMountSetting(String var1, String var2);

                public WithContainerInstanceAttach<ParentT> withReadOnlyVolumeMountSetting(Map<String, String> var1);
            }

            public static interface WithEnvironmentVariables<ParentT> {
                public WithContainerInstanceAttach<ParentT> withEnvironmentVariables(Map<String, String> var1);

                public WithContainerInstanceAttach<ParentT> withEnvironmentVariable(String var1, String var2);
            }

            public static interface WithStartingCommandLine<ParentT> {
                public WithContainerInstanceAttach<ParentT> withStartingCommandLines(String ... var1);

                public WithContainerInstanceAttach<ParentT> withStartingCommandLine(String var1);
            }

            public static interface WithMemorySize<ParentT> {
                public WithContainerInstanceAttach<ParentT> withMemorySizeInGB(double var1);
            }

            public static interface WithCpuCoreCount<ParentT> {
                public WithContainerInstanceAttach<ParentT> withCpuCoreCount(double var1);
            }

            public static interface WithPorts<ParentT> {
                public WithPortsOrContainerInstanceAttach<ParentT> withExternalTcpPorts(int ... var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withExternalTcpPort(int var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withExternalUdpPorts(int ... var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withExternalUdpPort(int var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withInternalPorts(int ... var1);

                public WithPortsOrContainerInstanceAttach<ParentT> withInternalPort(int var1);
            }

            public static interface WithPortsOrContainerInstanceAttach<ParentT>
            extends WithPorts<ParentT>,
            WithContainerInstanceAttach<ParentT> {
            }

            public static interface WithoutPorts<ParentT> {
                public WithContainerInstanceAttach<ParentT> withoutPorts();
            }

            public static interface WithOrWithoutPorts<ParentT>
            extends WithPorts<ParentT>,
            WithoutPorts<ParentT> {
            }

            public static interface WithImage<ParentT> {
                public WithOrWithoutPorts<ParentT> withImage(String var1);
            }

            public static interface ContainerInstanceDefinitionBlank<ParentT>
            extends WithImage<ParentT> {
            }
        }

        public static interface WithNextContainerInstance
        extends WithCreate {
            public ContainerInstanceDefinitionStages.ContainerInstanceDefinitionBlank<WithNextContainerInstance> defineContainerInstance(String var1);
        }

        public static interface WithFirstContainerInstance {
            public ContainerInstanceDefinitionStages.ContainerInstanceDefinitionBlank<WithNextContainerInstance> defineContainerInstance(String var1);

            public WithCreate withContainerInstance(String var1);

            public WithCreate withContainerInstance(String var1, int var2);
        }

        public static interface VolumeDefinitionStages {

            public static interface VolumeDefinition<ParentT>
            extends VolumeDefinitionBlank<ParentT>,
            WithAzureFileShare<ParentT>,
            WithStorageAccountName<ParentT>,
            WithStorageAccountKey<ParentT>,
            WithVolumeAttach<ParentT> {
            }

            public static interface WithVolumeAttach<ParentT>
            extends Attachable.InDefinition<ParentT> {
            }

            public static interface WithStorageAccountKey<ParentT> {
                public WithVolumeAttach<ParentT> withStorageAccountKey(String var1);
            }

            public static interface WithStorageAccountName<ParentT> {
                public WithStorageAccountKey<ParentT> withStorageAccountName(String var1);
            }

            public static interface WithAzureFileShare<ParentT> {
                public WithStorageAccountName<ParentT> withExistingReadWriteAzureFileShare(String var1);

                public WithStorageAccountName<ParentT> withExistingReadOnlyAzureFileShare(String var1);
            }

            public static interface VolumeDefinitionBlank<ParentT>
            extends WithAzureFileShare<ParentT> {
            }
        }

        public static interface WithVolume
        extends WithFirstContainerInstance {
            public VolumeDefinitionStages.VolumeDefinitionBlank<WithVolume> defineVolume(String var1);
        }

        public static interface WithPrivateImageRegistryOrVolume
        extends WithPrivateImageRegistry {
            public WithFirstContainerInstance withoutVolume();

            public WithFirstContainerInstance withNewAzureFileShareVolume(String var1, String var2);

            public VolumeDefinitionStages.VolumeDefinitionBlank<WithVolume> defineVolume(String var1);
        }

        public static interface WithPrivateImageRegistry {
            public WithPrivateImageRegistryOrVolume withPrivateImageRegistry(String var1, String var2, String var3);
        }

        public static interface WithPublicImageRegistryOnly {
            public WithPrivateImageRegistryOrVolume withPublicImageRegistryOnly();
        }

        public static interface WithPublicOrPrivateImageRegistry
        extends WithPublicImageRegistryOnly,
        WithPrivateImageRegistry {
        }

        public static interface WithOsType {
            public WithPublicOrPrivateImageRegistry withLinux();

            public WithPublicOrPrivateImageRegistry withWindows();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithOsType> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithOsType,
    DefinitionStages.WithPublicOrPrivateImageRegistry,
    DefinitionStages.WithPrivateImageRegistryOrVolume,
    DefinitionStages.WithVolume,
    DefinitionStages.WithFirstContainerInstance,
    DefinitionStages.WithNextContainerInstance,
    DefinitionStages.WithCreate {
    }
}

