/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.servicebus;

public class ServiceBusClientConfig {
    private final int prefetchCount;
    private final int concurrency;

    private ServiceBusClientConfig(int prefetchCount, int concurrency) {
        this.prefetchCount = prefetchCount;
        this.concurrency = concurrency;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public static ServiceBusClientConfigBuilder builder() {
        return new ServiceBusClientConfigBuilder();
    }

    public static class ServiceBusClientConfigBuilder {
        private int prefetchCount = 1;
        private int concurrency = 1;

        public ServiceBusClientConfigBuilder setPrefetchCount(int prefetchCount) {
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ServiceBusClientConfigBuilder setConcurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public ServiceBusClientConfig build() {
            return new ServiceBusClientConfig(this.prefetchCount, this.concurrency);
        }
    }
}

